/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.kotlin.BadSemver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class KtfmtStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_VERSION = "0.53";
    private static final String NAME = "ktfmt";
    private static final String MAVEN_COORDINATE = "com.facebook:ktfmt:";
    private final String version;
    @Nullable
    private final Style style;
    @Nullable
    private final KtfmtFormattingOptions options;
    private final JarState.Promised jarState;

    private KtfmtStep(String version, JarState.Promised jarState, @Nullable Style style, @Nullable KtfmtFormattingOptions options) {
        this.version = Objects.requireNonNull(version, "version");
        this.style = style;
        this.options = options;
        this.jarState = Objects.requireNonNull(jarState, "jarState");
    }

    public static FormatterStep create(Provisioner provisioner) {
        return KtfmtStep.create(KtfmtStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return KtfmtStep.create(version, provisioner, null, null);
    }

    public static FormatterStep create(String version, Provisioner provisioner, @Nullable Style style, @Nullable KtfmtFormattingOptions options) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.create(NAME, new KtfmtStep(version, JarState.promise(() -> JarState.from(MAVEN_COORDINATE + version, provisioner)), style, options), KtfmtStep::equalityState, State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private State equalityState() {
        return new State(this.version, this.jarState.get(), this.style, this.options);
    }

    public static enum Style {
        DEFAULT("DEFAULT_FORMAT", "0.0", "0.50"),
        META("META_FORMAT", "0.51"),
        DROPBOX("DROPBOX_FORMAT", "0.16", "0.50"),
        GOOGLE("GOOGLE_FORMAT", "0.19"),
        KOTLINLANG("KOTLINLANG_FORMAT", "0.21");

        private final String format;
        private final String since;
        @Nullable
        private final String until;

        private Style(String format, String since) {
            this.format = format;
            this.since = since;
            this.until = null;
        }

        private Style(@Nullable String format, String since, String until) {
            this.format = format;
            this.since = since;
            this.until = until;
        }

        String getFormat() {
            return this.format;
        }

        String getSince() {
            return this.since;
        }

        @Nullable
        String getUntil() {
            return this.until;
        }
    }

    public static class KtfmtFormattingOptions
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Nullable
        private Integer maxWidth = null;
        @Nullable
        private Integer blockIndent = null;
        @Nullable
        private Integer continuationIndent = null;
        @Nullable
        private Boolean removeUnusedImports = null;
        @Nullable
        private Boolean manageTrailingCommas = null;

        public KtfmtFormattingOptions() {
        }

        public KtfmtFormattingOptions(@Nullable Integer maxWidth, @Nullable Integer blockIndent, @Nullable Integer continuationIndent, @Nullable Boolean removeUnusedImports, @Nullable Boolean manageTrailingCommas) {
            this.maxWidth = maxWidth;
            this.blockIndent = blockIndent;
            this.continuationIndent = continuationIndent;
            this.removeUnusedImports = removeUnusedImports;
            this.manageTrailingCommas = manageTrailingCommas;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        public void setBlockIndent(int blockIndent) {
            this.blockIndent = blockIndent;
        }

        public void setContinuationIndent(int continuationIndent) {
            this.continuationIndent = continuationIndent;
        }

        public void setRemoveUnusedImports(boolean removeUnusedImports) {
            this.removeUnusedImports = removeUnusedImports;
        }

        public void setManageTrailingCommas(boolean manageTrailingCommas) {
            this.manageTrailingCommas = manageTrailingCommas;
        }
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String version;
        @Nullable
        private final Style style;
        @Nullable
        private final KtfmtFormattingOptions options;
        private final JarState jarState;

        State(String version, JarState jarState, @Nullable Style style, @Nullable KtfmtFormattingOptions options) {
            this.version = version;
            this.options = options;
            this.style = style;
            this.jarState = jarState;
            this.validateStyle();
            this.validateOptions();
        }

        FormatterFunc createFormat() throws Exception {
            Object ktfmtStyle;
            ClassLoader classLoader = this.jarState.getClassLoader();
            if (BadSemver.version(this.version) < BadSemver.version(0, 51)) {
                return new KtfmtFormatterFuncCompat(this.version, this.style, this.options, classLoader).getFormatterFunc();
            }
            Class<?> formatterFuncClass = classLoader.loadClass("com.diffplug.spotless.glue.ktfmt.KtfmtFormatterFunc");
            Class<?> ktfmtStyleClass = classLoader.loadClass("com.diffplug.spotless.glue.ktfmt.KtfmtStyle");
            Class<?> ktfmtFormattingOptionsClass = classLoader.loadClass("com.diffplug.spotless.glue.ktfmt.KtfmtFormattingOptions");
            if (this.style == null && this.options == null) {
                Constructor<?> constructor = formatterFuncClass.getConstructor(new Class[0]);
                return (FormatterFunc)constructor.newInstance(new Object[0]);
            }
            Object v0 = ktfmtStyle = this.style == null ? null : Enum.valueOf(ktfmtStyleClass, this.getKtfmtStyleOption(this.style));
            if (this.options == null) {
                Constructor<?> constructor = formatterFuncClass.getConstructor(ktfmtStyleClass);
                return (FormatterFunc)constructor.newInstance(ktfmtStyle);
            }
            Constructor<?> optionsConstructor = ktfmtFormattingOptionsClass.getConstructor(Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class);
            Object ktfmtFormattingOptions = optionsConstructor.newInstance(this.options.maxWidth, this.options.blockIndent, this.options.continuationIndent, this.options.removeUnusedImports, this.options.manageTrailingCommas);
            if (this.style == null) {
                Constructor<?> constructor = formatterFuncClass.getConstructor(ktfmtFormattingOptionsClass);
                return (FormatterFunc)constructor.newInstance(ktfmtFormattingOptions);
            }
            Constructor<?> constructor = formatterFuncClass.getConstructor(ktfmtStyleClass, ktfmtFormattingOptionsClass);
            return (FormatterFunc)constructor.newInstance(ktfmtStyle, ktfmtFormattingOptions);
        }

        private void validateOptions() {
            if (BadSemver.version(this.version) < BadSemver.version(0, 11)) {
                if (this.options != null) {
                    throw new IllegalStateException("Ktfmt formatting options supported for version 0.11 and later");
                }
                return;
            }
            if (BadSemver.version(this.version) < BadSemver.version(0, 17) && this.options != null && this.options.removeUnusedImports != null) {
                throw new IllegalStateException("Ktfmt formatting option `removeUnusedImports` supported for version 0.17 and later");
            }
        }

        private void validateStyle() {
            if (this.style == null) {
                return;
            }
            if (BadSemver.version(this.version) < BadSemver.version(this.style.since)) {
                throw new IllegalStateException(String.format("The style %s is available from version %s (current version: %s)", this.style.name(), this.style.since, this.version));
            }
            if (this.style.until != null && BadSemver.version(this.version) > BadSemver.version(this.style.until)) {
                throw new IllegalStateException(String.format("The style %s is no longer available from version %s (current version: %s)", this.style.name(), this.style.until, this.version));
            }
        }

        private String getKtfmtStyleOption(Style style) {
            switch (style) {
                case META: {
                    return "META";
                }
                case GOOGLE: {
                    return "GOOGLE";
                }
                case KOTLINLANG: {
                    return "KOTLIN_LANG";
                }
            }
            throw new IllegalStateException("Unsupported style: " + String.valueOf((Object)style));
        }
    }

    private static final class KtfmtFormatterFuncCompat {
        private static final String PACKAGE = "com.facebook.ktfmt";
        static final String FORMATTER_METHOD = "format";
        private final String version;
        private final Style style;
        private final KtfmtFormattingOptions options;
        private final ClassLoader classLoader;

        public KtfmtFormatterFuncCompat(String currentVersion, @Nullable Style style, @Nullable KtfmtFormattingOptions options, ClassLoader classLoader) {
            this.version = currentVersion;
            this.style = style;
            this.options = options;
            this.classLoader = classLoader;
        }

        public FormatterFunc getFormatterFunc() {
            return input -> {
                try {
                    return this.applyFormat(input);
                }
                catch (InvocationTargetException e) {
                    throw ThrowingEx.unwrapCause(e);
                }
            };
        }

        protected String applyFormat(String input) throws Exception {
            Class<?> formatterClass = this.getFormatterClazz();
            if (this.style == null && this.options == null || this.style == Style.DEFAULT) {
                Method formatterMethod = formatterClass.getMethod(FORMATTER_METHOD, String.class);
                return (String)formatterMethod.invoke(formatterClass, input);
            }
            Method formatterMethod = formatterClass.getMethod(FORMATTER_METHOD, this.getFormattingOptionsClazz(), String.class);
            Object formattingOptions = this.getCustomFormattingOptions(formatterClass);
            return (String)formatterMethod.invoke(formatterClass, formattingOptions, input);
        }

        private Object getCustomFormattingOptions(Class<?> formatterClass) throws Exception {
            Object formattingOptions = this.getFormattingOptionsFromStyle(formatterClass);
            Class<?> formattingOptionsClass = formattingOptions.getClass();
            if (this.options != null) {
                if (BadSemver.version(this.version) < BadSemver.version(0, 17)) {
                    formattingOptions = formattingOptions.getClass().getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(Optional.ofNullable(this.options.maxWidth).orElse((Integer)formattingOptionsClass.getMethod("getMaxWidth", new Class[0]).invoke(formattingOptions, new Object[0])), Optional.ofNullable(this.options.blockIndent).orElse((Integer)formattingOptionsClass.getMethod("getBlockIndent", new Class[0]).invoke(formattingOptions, new Object[0])), Optional.ofNullable(this.options.continuationIndent).orElse((Integer)formattingOptionsClass.getMethod("getContinuationIndent", new Class[0]).invoke(formattingOptions, new Object[0])));
                } else if (BadSemver.version(this.version) < BadSemver.version(0, 19)) {
                    formattingOptions = formattingOptions.getClass().getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE).newInstance(Optional.ofNullable(this.options.maxWidth).orElse((Integer)formattingOptionsClass.getMethod("getMaxWidth", new Class[0]).invoke(formattingOptions, new Object[0])), Optional.ofNullable(this.options.blockIndent).orElse((Integer)formattingOptionsClass.getMethod("getBlockIndent", new Class[0]).invoke(formattingOptions, new Object[0])), Optional.ofNullable(this.options.continuationIndent).orElse((Integer)formattingOptionsClass.getMethod("getContinuationIndent", new Class[0]).invoke(formattingOptions, new Object[0])), Optional.ofNullable(this.options.removeUnusedImports).orElse((Boolean)formattingOptionsClass.getMethod("getRemoveUnusedImports", new Class[0]).invoke(formattingOptions, new Object[0])), (Boolean)formattingOptionsClass.getMethod("getDebuggingPrintOpsAfterFormatting", new Class[0]).invoke(formattingOptions, new Object[0]));
                } else if (BadSemver.version(this.version) < BadSemver.version(0, 47)) {
                    Class<?> styleClass = this.classLoader.loadClass(formattingOptionsClass.getName() + "$Style");
                    formattingOptions = formattingOptions.getClass().getConstructor(styleClass, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE).newInstance(formattingOptionsClass.getMethod("getStyle", new Class[0]).invoke(formattingOptions, new Object[0]), Optional.ofNullable(this.options.maxWidth).orElse((Integer)formattingOptionsClass.getMethod("getMaxWidth", new Class[0]).invoke(formattingOptions, new Object[0])), Optional.ofNullable(this.options.blockIndent).orElse((Integer)formattingOptionsClass.getMethod("getBlockIndent", new Class[0]).invoke(formattingOptions, new Object[0])), Optional.ofNullable(this.options.continuationIndent).orElse((Integer)formattingOptionsClass.getMethod("getContinuationIndent", new Class[0]).invoke(formattingOptions, new Object[0])), Optional.ofNullable(this.options.removeUnusedImports).orElse((Boolean)formattingOptionsClass.getMethod("getRemoveUnusedImports", new Class[0]).invoke(formattingOptions, new Object[0])), (Boolean)formattingOptionsClass.getMethod("getDebuggingPrintOpsAfterFormatting", new Class[0]).invoke(formattingOptions, new Object[0]));
                } else {
                    Class<?> styleClass = this.classLoader.loadClass(formattingOptionsClass.getName() + "$Style");
                    formattingOptions = formattingOptions.getClass().getConstructor(styleClass, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE).newInstance(formattingOptionsClass.getMethod("getStyle", new Class[0]).invoke(formattingOptions, new Object[0]), Optional.ofNullable(this.options.maxWidth).orElse((Integer)formattingOptionsClass.getMethod("getMaxWidth", new Class[0]).invoke(formattingOptions, new Object[0])), Optional.ofNullable(this.options.blockIndent).orElse((Integer)formattingOptionsClass.getMethod("getBlockIndent", new Class[0]).invoke(formattingOptions, new Object[0])), Optional.ofNullable(this.options.continuationIndent).orElse((Integer)formattingOptionsClass.getMethod("getContinuationIndent", new Class[0]).invoke(formattingOptions, new Object[0])), Optional.ofNullable(this.options.removeUnusedImports).orElse((Boolean)formattingOptionsClass.getMethod("getRemoveUnusedImports", new Class[0]).invoke(formattingOptions, new Object[0])), (Boolean)formattingOptionsClass.getMethod("getDebuggingPrintOpsAfterFormatting", new Class[0]).invoke(formattingOptions, new Object[0]), Optional.ofNullable(this.options.manageTrailingCommas).orElse((Boolean)formattingOptionsClass.getMethod("getManageTrailingCommas", new Class[0]).invoke(formattingOptions, new Object[0])));
                }
            }
            return formattingOptions;
        }

        private Object getFormattingOptionsFromStyle(Class<?> formatterClass) throws Exception {
            Style style = this.style;
            if (style == null) {
                style = BadSemver.version(this.version) < BadSemver.version(0, 51) ? Style.DEFAULT : Style.META;
            }
            if (BadSemver.version(this.version) < BadSemver.version(0, 19)) {
                if (style != Style.DROPBOX) {
                    throw new IllegalStateException("Invalid style " + String.valueOf((Object)style) + " for version " + this.version);
                }
                Class<?> formattingOptionsCompanionClazz = this.classLoader.loadClass("com.facebook.ktfmt.FormattingOptions$Companion");
                Object companion = formattingOptionsCompanionClazz.getConstructors()[0].newInstance(new Object[]{null});
                Method formattingOptionsMethod = formattingOptionsCompanionClazz.getDeclaredMethod("dropboxStyle", new Class[0]);
                return formattingOptionsMethod.invoke(companion, new Object[0]);
            }
            return formatterClass.getField(style.getFormat()).get(null);
        }

        private Class<?> getFormatterClazz() throws Exception {
            Class<?> formatterClazz = BadSemver.version(this.version) >= BadSemver.version(0, 31) ? this.classLoader.loadClass("com.facebook.ktfmt.format.Formatter") : this.classLoader.loadClass("com.facebook.ktfmt.FormatterKt");
            return formatterClazz;
        }

        private Class<?> getFormattingOptionsClazz() throws Exception {
            Class<?> formattingOptionsClazz = BadSemver.version(this.version) >= BadSemver.version(0, 31) ? this.classLoader.loadClass("com.facebook.ktfmt.format.FormattingOptions") : this.classLoader.loadClass("com.facebook.ktfmt.FormattingOptions");
            return formattingOptionsClazz;
        }
    }
}

