/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.markdown;

import com.diffplug.spotless.FormatterFunc;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.profile.pegdown.PegdownOptionsAdapter;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.misc.Extension;
import java.util.Collection;

public class FlexmarkFormatterFunc
implements FormatterFunc {
    private static final String DEFAULT_EMULATION_PROFILE = "COMMONMARK";
    private final Parser parser;
    private final Formatter formatter;

    public FlexmarkFormatterFunc() {
        ParserEmulationProfile emulationProfile = ParserEmulationProfile.valueOf((String)DEFAULT_EMULATION_PROFILE);
        MutableDataHolder parserOptions = FlexmarkFormatterFunc.createParserOptions(emulationProfile);
        MutableDataHolder formatterOptions = FlexmarkFormatterFunc.createFormatterOptions(parserOptions, emulationProfile);
        this.parser = Parser.builder((DataHolder)parserOptions).build();
        this.formatter = Formatter.builder((DataHolder)formatterOptions).build();
    }

    private static MutableDataHolder createParserOptions(ParserEmulationProfile emulationProfile) {
        MutableDataHolder parserOptions = PegdownOptionsAdapter.flexmarkOptions((int)65535, (Extension[])new Extension[0]).toMutable();
        parserOptions.set(Parser.PARSER_EMULATION_PROFILE, (Object)emulationProfile);
        return parserOptions;
    }

    private static MutableDataHolder createFormatterOptions(MutableDataHolder parserOptions, ParserEmulationProfile emulationProfile) {
        MutableDataSet formatterOptions = new MutableDataSet();
        formatterOptions.set(Parser.EXTENSIONS, (Object)((Collection)Parser.EXTENSIONS.get((DataHolder)parserOptions)));
        formatterOptions.set(Formatter.FORMATTER_EMULATION_PROFILE, (Object)emulationProfile);
        return formatterOptions;
    }

    @Override
    public String apply(String input) throws Exception {
        Document parsedMarkdown = this.parser.parse(input);
        return this.formatter.render((Node)parsedMarkdown);
    }
}

