/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.ProcessRunner;
import com.diffplug.spotless.npm.NodeServerLayout;
import com.diffplug.spotless.npm.NpmFormatterStepLocations;
import com.diffplug.spotless.npm.NpmLongRunningProcess;
import com.diffplug.spotless.npm.NpmProcess;
import com.diffplug.spotless.npm.NpmProcessException;
import com.diffplug.spotless.npm.NpmProcessFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class StandardNpmProcessFactory
implements NpmProcessFactory {
    public static final StandardNpmProcessFactory INSTANCE = new StandardNpmProcessFactory();

    private StandardNpmProcessFactory() {
    }

    @Override
    public NpmProcess createNpmInstallProcess(NodeServerLayout nodeServerLayout, NpmFormatterStepLocations formatterStepLocations, NpmProcessFactory.OnlinePreferrence onlinePreferrence) {
        return new NpmInstall(nodeServerLayout.nodeModulesDir(), formatterStepLocations, onlinePreferrence);
    }

    @Override
    public NpmLongRunningProcess createNpmServeProcess(NodeServerLayout nodeServerLayout, NpmFormatterStepLocations formatterStepLocations) {
        return new NpmServe(nodeServerLayout.nodeModulesDir(), formatterStepLocations);
    }

    private static class NpmInstall
    extends AbstractStandardNpmProcess
    implements NpmProcess {
        private final NpmProcessFactory.OnlinePreferrence onlinePreferrence;

        public NpmInstall(File workingDir, NpmFormatterStepLocations formatterStepLocations, NpmProcessFactory.OnlinePreferrence onlinePreferrence) {
            super(workingDir, formatterStepLocations);
            this.onlinePreferrence = onlinePreferrence;
        }

        @Override
        protected List<String> commandLine() {
            return List.of(this.npmExecutable(), "install", "--no-audit", "--no-fund", this.onlinePreferrence.option());
        }

        @Override
        public String describe() {
            return this.doDescribe();
        }

        @Override
        public ProcessRunner.Result waitFor() {
            ProcessRunner.LongRunningProcess npmProcess = this.doStart();
            try {
                if (npmProcess.waitFor() != 0) {
                    throw new NpmProcessException("Running npm command '" + this.describe() + "' failed with exit code: " + npmProcess.exitValue() + "\n\n" + String.valueOf(npmProcess.result()), npmProcess.result());
                }
                ProcessRunner.Result result = npmProcess.result();
                if (npmProcess != null) {
                    npmProcess.close();
                }
                return result;
            }
            catch (Throwable throwable) {
                try {
                    if (npmProcess != null) {
                        try {
                            npmProcess.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw new NpmProcessException("Running npm command '" + this.describe() + "' was interrupted.", e);
                }
                catch (ExecutionException e) {
                    throw new NpmProcessException("Running npm command '" + this.describe() + "' failed.", e);
                }
            }
        }
    }

    private static class NpmServe
    extends AbstractStandardNpmProcess
    implements NpmLongRunningProcess {
        public NpmServe(File workingDir, NpmFormatterStepLocations formatterStepLocations) {
            super(workingDir, formatterStepLocations);
        }

        @Override
        protected List<String> commandLine() {
            return List.of(this.npmExecutable(), "start", "--scripts-prepend-node-path=true");
        }

        @Override
        public String describe() {
            return this.doDescribe();
        }

        @Override
        public ProcessRunner.LongRunningProcess start() {
            return this.doStart();
        }
    }

    private static abstract class AbstractStandardNpmProcess {
        protected final ProcessRunner processRunner = ProcessRunner.usingRingBuffersOfCapacity(102400);
        protected final File workingDir;
        protected final NpmFormatterStepLocations formatterStepLocations;

        public AbstractStandardNpmProcess(File workingDir, NpmFormatterStepLocations formatterStepLocations) {
            this.formatterStepLocations = formatterStepLocations;
            this.workingDir = workingDir;
        }

        protected String npmExecutable() {
            return this.formatterStepLocations.npmExecutable().getAbsolutePath();
        }

        protected abstract List<String> commandLine();

        protected Map<String, String> environmentVariables() {
            return Map.of("PATH", this.formatterStepLocations.nodeExecutable().getParentFile().getAbsolutePath() + File.pathSeparator + System.getenv("PATH"));
        }

        protected ProcessRunner.LongRunningProcess doStart() {
            try {
                return this.processRunner.start(this.workingDir, this.environmentVariables(), null, true, this.commandLine());
            }
            catch (IOException e) {
                throw new NpmProcessException("Failed to launch npm command '" + this.describe() + "'.", e);
            }
        }

        protected abstract String describe();

        public String doDescribe() {
            return String.format("%s in %s [%s]", this.getClass().getSimpleName(), this.workingDir, String.join((CharSequence)" ", this.commandLine()));
        }
    }
}

