/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.ThrowingEx;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Lint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int lineStart;
    private int lineEnd;
    private String shortCode;
    private String detail;
    public static final int LINE_UNDEFINED = -1;

    public static Lint atUndefinedLine(String ruleId, String detail) {
        return new Lint(-1, ruleId, detail);
    }

    public static Lint atLine(int line, String ruleId, String detail) {
        return new Lint(line, ruleId, detail);
    }

    public static Lint atLineRange(int lineStart, int lineEnd, String shortCode, String detail) {
        return new Lint(lineStart, lineEnd, shortCode, detail);
    }

    private Lint(int lineStart, int lineEnd, String shortCode, String detail) {
        if (lineEnd < lineStart) {
            throw new IllegalArgumentException("lineEnd must be >= lineStart: lineStart=" + lineStart + " lineEnd=" + lineEnd);
        }
        this.lineStart = lineStart;
        this.lineEnd = lineEnd;
        this.shortCode = LineEnding.toUnix(shortCode);
        this.detail = LineEnding.toUnix(detail);
    }

    private Lint(int line, String shortCode, String detail) {
        this(line, line, shortCode, detail);
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public int getLineEnd() {
        return this.lineEnd;
    }

    public String getShortCode() {
        return this.shortCode;
    }

    public String getDetail() {
        return this.detail;
    }

    public static RuntimeException shortcut(Collection<Lint> lints) {
        return new ShortcutException(lints);
    }

    public RuntimeException shortcut() {
        return new ShortcutException(this);
    }

    public String toString() {
        if (this.lineStart == this.lineEnd) {
            if (this.lineStart == -1) {
                return "LINE_UNDEFINED: (" + this.shortCode + ") " + this.detail;
            }
            return "L" + this.lineStart + ": (" + this.shortCode + ") " + this.detail;
        }
        return "L" + this.lineStart + "-" + this.lineEnd + ": (" + this.shortCode + ") " + this.detail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lint lint = (Lint)o;
        return this.lineStart == lint.lineStart && this.lineEnd == lint.lineEnd && Objects.equals(this.shortCode, lint.shortCode) && Objects.equals(this.detail, lint.detail);
    }

    public int hashCode() {
        return Objects.hash(this.lineStart, this.lineEnd, this.shortCode, this.detail);
    }

    static Lint createFromThrowable(FormatterStep step, Throwable e) {
        for (Throwable current = e; current != null; current = current.getCause()) {
            String message = current.getMessage();
            int lineNumber = Lint.lineNumberFor(message);
            if (lineNumber == -1) continue;
            return new Lint(lineNumber, step.getName(), Lint.msgFrom(message));
        }
        String exceptionName = e.getClass().getName();
        String detail = ThrowingEx.stacktrace(e);
        if (detail.startsWith(exceptionName + ": ")) {
            detail = detail.substring(exceptionName.length() + 2);
        }
        Matcher matcher = Pattern.compile("line (\\d+)").matcher(detail);
        int line = -1;
        if (matcher.find()) {
            line = Integer.parseInt(matcher.group(1));
        }
        return Lint.atLine(line, exceptionName, detail);
    }

    private static int lineNumberFor(String message) {
        if (message == null) {
            return -1;
        }
        int firstColon = message.indexOf(58);
        if (firstColon == -1) {
            return -1;
        }
        String candidateNum = message.substring(0, firstColon);
        try {
            return Integer.parseInt(candidateNum);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String msgFrom(String message) {
        for (int i = 0; i < message.length(); ++i) {
            if (!Character.isLetter(message.charAt(i))) continue;
            return message.substring(i);
        }
        return "";
    }

    public void addWarningMessageTo(StringBuilder buffer, String stepName, boolean oneLine) {
        if (this.lineStart == -1) {
            buffer.append("LINE_UNDEFINED");
        } else {
            buffer.append("L");
            buffer.append(this.lineStart);
            if (this.lineEnd != this.lineStart) {
                buffer.append("-").append(this.lineEnd);
            }
        }
        buffer.append(" ");
        buffer.append(stepName).append("(").append(this.shortCode).append(") ");
        int firstNewline = this.detail.indexOf(10);
        if (firstNewline == -1) {
            buffer.append(this.detail);
        } else if (oneLine) {
            buffer.append(this.detail, 0, firstNewline);
            buffer.append(" (...)");
        } else {
            buffer.append(this.detail);
        }
    }

    static class ShortcutException
    extends RuntimeException
    implements Has {
        private final List<Lint> lints;

        public ShortcutException(Lint ... lints) {
            this(Arrays.asList(lints));
        }

        ShortcutException(Collection<Lint> lints) {
            super(lints.iterator().next().detail);
            this.lints = List.copyOf(lints);
        }

        @Override
        public List<Lint> getLints() {
            return this.lints;
        }
    }

    public static interface Has {
        public List<Lint> getLints();
    }
}

