/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.SerializedFunction;
import java.io.Serializable;

public final class IndentStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    final Type type;
    final int numSpacesPerTab;
    private static final int DEFAULT_NUM_SPACES_PER_TAB = 4;

    private IndentStep(Type type, int numSpacesPerTab) {
        this.type = type;
        this.numSpacesPerTab = numSpacesPerTab;
    }

    public static FormatterStep create(Type type, int numSpacesPerTab) {
        return FormatterStep.create("indentWith" + type.tabSpace("Tabs", "Spaces"), new IndentStep(type, numSpacesPerTab), SerializedFunction.identity(), IndentStep::startFormatting);
    }

    private FormatterFunc startFormatting() {
        Runtime runtime = new Runtime(this);
        return runtime::format;
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    public static int defaultNumSpacesPerTab() {
        return 4;
    }

    public static enum Type {
        TAB,
        SPACE;


        private <T> T tabSpace(T tab, T space) {
            return this == TAB ? tab : space;
        }

        public FormatterStep create() {
            return IndentStep.create(this, IndentStep.defaultNumSpacesPerTab());
        }

        public FormatterStep create(int numSpacesPerTab) {
            return IndentStep.create(this, numSpacesPerTab);
        }
    }

    static class Runtime {
        final IndentStep state;
        final StringBuilder builder = new StringBuilder();

        Runtime(IndentStep state) {
            this.state = state;
        }

        String format(String raw) {
            this.builder.setLength(0);
            int lineStart = 0;
            while (true) {
                boolean mightBeMultiLineComment;
                char c;
                int contentStart;
                int numSpaces = 0;
                block9: for (contentStart = lineStart; contentStart < raw.length() && IndentStep.isSpaceOrTab(c = raw.charAt(contentStart)); ++contentStart) {
                    switch (c) {
                        case ' ': {
                            ++numSpaces;
                            continue block9;
                        }
                        case '\t': {
                            numSpaces += this.state.numSpacesPerTab;
                            continue block9;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected char " + c);
                        }
                    }
                }
                boolean bl = mightBeMultiLineComment = contentStart < raw.length() && raw.charAt(contentStart) == '*';
                if (numSpaces > 0) {
                    switch (this.state.type) {
                        case SPACE: {
                            int i;
                            for (i = 0; i < numSpaces; ++i) {
                                this.builder.append(' ');
                            }
                            break;
                        }
                        case TAB: {
                            int i;
                            for (i = 0; i < numSpaces / this.state.numSpacesPerTab; ++i) {
                                this.builder.append('\t');
                            }
                            if (!mightBeMultiLineComment || numSpaces % this.state.numSpacesPerTab != 1) break;
                            this.builder.append(' ');
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected enum " + this.state.type);
                        }
                    }
                }
                if ((lineStart = raw.indexOf(10, contentStart)) == -1) {
                    this.builder.append(raw.subSequence(contentStart, raw.length()));
                    return this.builder.toString();
                }
                this.builder.append(raw.subSequence(contentStart, ++lineStart));
            }
        }
    }
}

