/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.rdf;

import com.diffplug.spotless.rdf.RdfFormatterStep;
import java.io.File;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReflectionHelper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final RdfFormatterStep.State state;
    private final ClassLoader classLoader;
    private final Class<?> JenaRdfDataMgrClass;
    private final Class<?> JenaRdfParserClass;
    private final Class<?> JenaRdfParserBuilderClass;
    private final Class<?> JenaErrorHandlerClass;
    private final Class<?> JenaModelClass;
    private final Class<?> JenaStmtIteratorClass;
    private final Class<?> JenaStatementClass;
    private final Class<?> JenaRDFNodeClass;
    private final Class<?> JenaResourceClass;
    private final Class<?> JenaPropertyClass;
    private final Class<?> JenaModelFactoryClass;
    private final Class<?> JenaLangClass;
    private final Class<?> JenaRDFFormatClass;
    private final Class<?> JenaGraphClass;
    private final Class<?> JenaTriple;
    private final Class<?> TurtleFormatFormattingStyleClass;
    private final Class<?> TurtleFormatFormattingStyleBuilderClass;
    private final Class<?> TurtleFormatFormatterClass;
    private final Class<?> TurtleFormatKnownPrefix;
    private final Method graphStream;
    private final Method graphFindTriple;
    private final Method contains;
    private final Method getSubject;
    private final Method getPredicate;
    private final Method getObject;
    private final Method isAnon;
    private final Method getGraph;
    private final Method tripleGetObject;
    private Object turtleFormatter = null;
    private Object jenaModelInstance = null;

    public ReflectionHelper(RdfFormatterStep.State state) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        this.state = state;
        this.classLoader = state.getJarState().getClassLoader();
        this.JenaRdfDataMgrClass = this.classLoader.loadClass("org.apache.jena.riot.RDFDataMgr");
        this.JenaRdfParserClass = this.classLoader.loadClass("org.apache.jena.riot.RDFParser");
        this.JenaRdfParserBuilderClass = this.classLoader.loadClass("org.apache.jena.riot.RDFParserBuilder");
        this.JenaErrorHandlerClass = this.classLoader.loadClass("org.apache.jena.riot.system.ErrorHandler");
        this.JenaModelClass = this.classLoader.loadClass("org.apache.jena.rdf.model.Model");
        this.JenaStmtIteratorClass = this.classLoader.loadClass("org.apache.jena.rdf.model.StmtIterator");
        this.JenaRDFNodeClass = this.classLoader.loadClass("org.apache.jena.rdf.model.RDFNode");
        this.JenaResourceClass = this.classLoader.loadClass("org.apache.jena.rdf.model.Resource");
        this.JenaPropertyClass = this.classLoader.loadClass("org.apache.jena.rdf.model.Property");
        this.JenaStatementClass = this.classLoader.loadClass("org.apache.jena.rdf.model.Statement");
        this.JenaModelFactoryClass = this.classLoader.loadClass("org.apache.jena.rdf.model.ModelFactory");
        this.JenaLangClass = this.classLoader.loadClass("org.apache.jena.riot.Lang");
        this.JenaRDFFormatClass = this.classLoader.loadClass("org.apache.jena.riot.RDFFormat");
        this.TurtleFormatFormatterClass = this.classLoader.loadClass("de.atextor.turtle.formatter.TurtleFormatter");
        this.TurtleFormatFormattingStyleClass = this.classLoader.loadClass("de.atextor.turtle.formatter.FormattingStyle");
        Class<?>[] innerClasses = this.TurtleFormatFormattingStyleClass.getDeclaredClasses();
        this.TurtleFormatFormattingStyleBuilderClass = Arrays.stream(innerClasses).filter(c -> c.getSimpleName().equals("FormattingStyleBuilder")).findFirst().get();
        this.TurtleFormatKnownPrefix = Arrays.stream(innerClasses).filter(c -> c.getSimpleName().equals("KnownPrefix")).findFirst().get();
        this.getSubject = this.JenaStatementClass.getMethod("getSubject", new Class[0]);
        this.getPredicate = this.JenaStatementClass.getMethod("getPredicate", new Class[0]);
        this.getObject = this.JenaStatementClass.getMethod("getObject", new Class[0]);
        this.isAnon = this.JenaRDFNodeClass.getMethod("isAnon", new Class[0]);
        this.getGraph = this.JenaModelClass.getMethod("getGraph", new Class[0]);
        this.JenaGraphClass = this.classLoader.loadClass("org.apache.jena.graph.Graph");
        this.JenaTriple = this.classLoader.loadClass("org.apache.jena.graph.Triple");
        this.graphFindTriple = this.JenaGraphClass.getMethod("find", this.JenaTriple);
        this.graphStream = this.JenaGraphClass.getMethod("stream", new Class[0]);
        this.tripleGetObject = this.JenaTriple.getMethod("getObject", new Class[0]);
        this.contains = this.JenaGraphClass.getMethod("contains", this.JenaTriple);
        this.jenaModelInstance = this.JenaModelFactoryClass.getMethod("createDefaultModel", new Class[0]).invoke(this.JenaModelFactoryClass, new Object[0]);
    }

    public Object getLang(String lang) throws NoSuchFieldException, IllegalAccessException {
        return this.JenaLangClass.getDeclaredField(lang).get(this.JenaLangClass);
    }

    public Object getModel() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return this.JenaModelFactoryClass.getMethod("createDefaultModel", new Class[0]).invoke(this.JenaModelFactoryClass, new Object[0]);
    }

    public Object getErrorHandler(File file) {
        return Proxy.newProxyInstance(this.classLoader, new Class[]{this.JenaErrorHandlerClass}, (InvocationHandler)new DynamicErrorInvocationHandler(file));
    }

    public Object listModelStatements(Object modelBefore) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method listStatements = this.JenaModelClass.getMethod("listStatements", new Class[0]);
        return listStatements.invoke(modelBefore, new Object[0]);
    }

    public boolean hasNext(Object statementIterator) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method hasNext = this.JenaStmtIteratorClass.getMethod("hasNext", new Class[0]);
        return (Boolean)hasNext.invoke(statementIterator, new Object[0]);
    }

    public Object next(Object statementIterator) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method hasNext = this.JenaStmtIteratorClass.getMethod("next", new Class[0]);
        return hasNext.invoke(statementIterator, new Object[0]);
    }

    public boolean containsBlankNode(Object statement) throws InvocationTargetException, IllegalAccessException {
        Object subject = this.getSubject.invoke(statement, new Object[0]);
        if (((Boolean)this.isAnon.invoke(subject, new Object[0])).booleanValue()) {
            return true;
        }
        Object predicate = this.getPredicate.invoke(statement, new Object[0]);
        if (((Boolean)this.isAnon.invoke(predicate, new Object[0])).booleanValue()) {
            return true;
        }
        Object object = this.getObject.invoke(statement, new Object[0]);
        return (Boolean)this.isAnon.invoke(object, new Object[0]);
    }

    public boolean containsStatement(Object model, Object statement) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method contains = this.JenaModelClass.getMethod("contains", this.JenaStatementClass);
        return (Boolean)contains.invoke(model, statement);
    }

    public boolean graphContainsSameTerm(Object graph, Object triple) throws InvocationTargetException, IllegalAccessException {
        boolean found = (Boolean)this.contains.invoke(graph, triple);
        if (!found) {
            return false;
        }
        Iterator it = (Iterator)this.graphFindTriple.invoke(graph, triple);
        while (it.hasNext()) {
            Object searchedObject;
            Object foundTriple = it.next();
            Object foundObject = this.tripleGetObject.invoke(foundTriple, new Object[0]);
            if (foundObject.equals(searchedObject = this.tripleGetObject.invoke(triple, new Object[0]))) continue;
            return false;
        }
        return true;
    }

    public Object getParser(Object lang, Object errorHandler, String rawUnix) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object parserBuilder = this.JenaRdfParserClass.getMethod("create", new Class[0]).invoke(this.JenaRdfParserClass, new Object[0]);
        parserBuilder = this.JenaRdfParserBuilderClass.getMethod("errorHandler", this.JenaErrorHandlerClass).invoke(parserBuilder, errorHandler);
        parserBuilder = this.JenaRdfParserBuilderClass.getMethod("forceLang", this.JenaLangClass).invoke(parserBuilder, lang);
        parserBuilder = this.JenaRdfParserBuilderClass.getMethod("strict", Boolean.TYPE).invoke(parserBuilder, true);
        parserBuilder = this.JenaRdfParserBuilderClass.getMethod("checking", Boolean.TYPE).invoke(parserBuilder, true);
        parserBuilder = this.JenaRdfParserBuilderClass.getMethod("fromString", String.class).invoke(parserBuilder, rawUnix);
        return this.JenaRdfParserBuilderClass.getMethod("build", new Class[0]).invoke(parserBuilder, new Object[0]);
    }

    public void parseModel(Object parser, Object model) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        this.JenaRdfParserClass.getMethod("parse", this.JenaModelClass).invoke(parser, model);
    }

    public Object getGraph(Object model) throws InvocationTargetException, IllegalAccessException {
        return this.getGraph.invoke(model, new Object[0]);
    }

    public Stream<Object> streamGraph(Object graph) throws InvocationTargetException, IllegalAccessException {
        return (Stream)this.graphStream.invoke(graph, new Object[0]);
    }

    public String formatWithJena(Object model, Object rdfFormat) throws NoSuchMethodException, NoSuchFieldException, InvocationTargetException, IllegalAccessException {
        StringWriter sw = new StringWriter();
        this.JenaRdfDataMgrClass.getMethod("write", StringWriter.class, this.JenaModelClass, this.JenaRDFFormatClass).invoke(this.JenaRdfDataMgrClass, sw, model, rdfFormat);
        return sw.toString();
    }

    public String formatWithTurtleFormatter(Object model) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Object formatter = this.getTurtleFormatter();
        return (String)this.TurtleFormatFormatterClass.getMethod("apply", this.JenaModelClass).invoke(formatter, model);
    }

    private synchronized Object getTurtleFormatter() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        if (this.turtleFormatter == null) {
            Object style = this.newTurtleFormatterStyle();
            this.turtleFormatter = this.newTurtleFormatter(style);
        }
        return this.turtleFormatter;
    }

    private Object newTurtleFormatterStyle() throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object builder = this.TurtleFormatFormattingStyleClass.getMethod("builder", new Class[0]).invoke(this.TurtleFormatFormatterClass, new Object[0]);
        for (String optionName : this.state.getTurtleFormatterStyle().keySet()) {
            Method method = this.getBuilderMethod(optionName);
            this.callBuilderMethod(builder, method, this.state.getTurtleFormatterStyle().get(optionName));
        }
        Object style = this.TurtleFormatFormattingStyleBuilderClass.getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        return style;
    }

    public String formatWithTurtleFormatter(String ttlContent) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Object style = this.newTurtleFormatterStyle();
        Object formatter = this.newTurtleFormatter(style);
        return (String)this.TurtleFormatFormatterClass.getMethod("applyToContent", String.class).invoke(formatter, ttlContent);
    }

    private Object newTurtleFormatter(Object style) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object formatter = this.TurtleFormatFormatterClass.getConstructor(this.TurtleFormatFormattingStyleClass).newInstance(style);
        return formatter;
    }

    private void callBuilderMethod(Object builder, Method method, String parameterValueAsString) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class<?> param = method.getParameterTypes()[0];
        if (param.isEnum()) {
            List selectedEnumValueList = Arrays.stream(param.getEnumConstants()).filter(e -> {
                try {
                    return e.getClass().getMethod("name", new Class[0]).invoke(e, new Object[0]).equals(parameterValueAsString);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }).collect(Collectors.toList());
            if (selectedEnumValueList.isEmpty()) {
                throw new IllegalArgumentException(String.format("Cannot set config option %s to value %s: value must be one of %s", method.getName(), parameterValueAsString, Arrays.stream(param.getEnumConstants()).map(e -> {
                    try {
                        return (String)e.getClass().getMethod("name", new Class[0]).invoke(e, new Object[0]);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                        throw new RuntimeException(ex);
                    }
                }).collect(Collectors.joining(",", "[", "]"))));
            }
            if (selectedEnumValueList.size() > 1) {
                throw new IllegalArgumentException(String.format("Found more than 1 enum value for name %s, that should never happen", parameterValueAsString));
            }
            method.invoke(builder, selectedEnumValueList.get(0));
        } else if (param.equals(NumberFormat.class)) {
            method.invoke(builder, new DecimalFormat(parameterValueAsString, DecimalFormatSymbols.getInstance(Locale.US)));
        } else if (param.equals(Boolean.class) || param.equals(Boolean.TYPE)) {
            method.invoke(builder, Boolean.parseBoolean(parameterValueAsString));
        } else if (param.equals(String.class)) {
            method.invoke(builder, parameterValueAsString);
        } else if (param.equals(Integer.class)) {
            method.invoke(builder, Integer.parseInt(parameterValueAsString));
        } else if (param.equals(Double.class)) {
            method.invoke(builder, Double.parseDouble(parameterValueAsString));
        } else if (param.equals(Long.class)) {
            method.invoke(builder, Long.parseLong(parameterValueAsString));
        } else if (param.equals(Float.class)) {
            method.invoke(builder, Float.valueOf(Float.parseFloat(parameterValueAsString)));
        } else if (Set.class.isAssignableFrom(param)) {
            method.invoke(builder, this.makeSetOf(((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()[0], parameterValueAsString));
        } else if (List.class.isAssignableFrom(param)) {
            method.invoke(builder, this.makeListOf(((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()[0], parameterValueAsString));
        } else {
            throw new IllegalArgumentException(String.format("Cannot handle turtle-formatter config option %s: parameters of type %s are not implemented in the spotless plugin yet", method.getName(), param.getName()));
        }
    }

    private Object makeListOf(Type type, String parameterValueAsString) {
        String[] entries = ReflectionHelper.split(parameterValueAsString);
        List ret = Arrays.stream(entries).map(e -> {
            try {
                return this.instantiate(type, (String)e);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.toList());
        return ret;
    }

    private Object makeSetOf(Type type, String parameterValueAsString) {
        String[] entries = ReflectionHelper.split(parameterValueAsString);
        return Arrays.stream(entries).map(e -> {
            try {
                return this.instantiate(type, (String)e);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.toSet());
    }

    private Object instantiate(Type type, String stringRepresentation) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String uri;
        if (type.equals(String.class)) {
            return stringRepresentation;
        }
        if (type.equals(this.JenaRDFNodeClass)) {
            try {
                String uri2 = this.tryToMakeUri(stringRepresentation);
                return this.JenaModelClass.getMethod("createResource", String.class).invoke(this.jenaModelInstance, uri2);
            }
            catch (IllegalArgumentException e) {
                return this.JenaModelClass.getMethod("createLiteral", String.class, String.class).invoke(this.jenaModelInstance, stringRepresentation, "");
            }
        }
        if (type.equals(this.JenaResourceClass)) {
            return this.JenaModelClass.getMethod("createResource", String.class).invoke(this.jenaModelInstance, this.tryToMakeUri(stringRepresentation));
        }
        if (type.equals(this.JenaPropertyClass) && (uri = this.tryToMakeUri(stringRepresentation)) != null) {
            String localname = uri.replaceAll("^.+[#/]", "");
            String namespace = uri.substring(0, uri.length() - localname.length());
            return this.JenaModelClass.getMethod("createProperty", String.class, String.class).invoke(this.jenaModelInstance, namespace, localname);
        }
        if (type.equals(this.TurtleFormatKnownPrefix)) {
            return this.getKnownPrefix(stringRepresentation);
        }
        throw new IllegalArgumentException(String.format("Cannot instantiate class %s from string representation %s", type, stringRepresentation));
    }

    private String tryToMakeUri(String stringRepresentation) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        if (stringRepresentation.matches("[^:/]+:[^:/]+")) {
            int colonIndex = stringRepresentation.indexOf(58);
            String prefix = stringRepresentation.substring(0, colonIndex);
            Object knownPrefix = this.getKnownPrefix(prefix);
            String base = this.TurtleFormatKnownPrefix.getMethod("iri", new Class[0]).invoke(knownPrefix, new Object[0]).toString();
            return base + stringRepresentation.substring(colonIndex + 1);
        }
        URI uri = URI.create(stringRepresentation);
        return uri.toString();
    }

    private Object getKnownPrefix(String stringRepresentation) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Field[] fields = this.TurtleFormatFormattingStyleClass.getDeclaredFields();
        ArrayList<String> options = new ArrayList<String>();
        for (Field field : fields) {
            if (!field.getType().equals(this.TurtleFormatKnownPrefix)) continue;
            Object knownPrefix = field.get(this.TurtleFormatFormattingStyleClass);
            String prefix = (String)this.TurtleFormatKnownPrefix.getMethod("prefix", new Class[0]).invoke(knownPrefix, new Object[0]);
            options.add(prefix);
            if (!stringRepresentation.equals(prefix)) continue;
            return knownPrefix;
        }
        throw new IllegalArgumentException(String.format("Unable to find FormattingStyle.KnownPrefix for prefix '%s'. Options are: %s", stringRepresentation, options.stream().collect(Collectors.joining(",\n\t", "\n\t", "\n"))));
    }

    private static String[] split(String parameterValueAsString) {
        if (parameterValueAsString == null || parameterValueAsString.isBlank()) {
            return new String[0];
        }
        return parameterValueAsString.split("\\s*(,|,\\s*\n|\n)\\s*");
    }

    private Method getBuilderMethod(String optionName) {
        Method[] allMethods = this.TurtleFormatFormattingStyleBuilderClass.getDeclaredMethods();
        List methods = Arrays.stream(allMethods).filter(m -> m.getName().equals(optionName)).collect(Collectors.toList());
        if (methods.isEmpty()) {
            List candidates = Arrays.stream(allMethods).filter(m -> m.getParameterCount() == 1).sorted(Comparator.comparing(Method::getName)).collect(Collectors.toList());
            throw new RuntimeException(String.format("Unrecognized configuration parameter name: %s. Candidates are:%n%s", optionName, candidates.stream().map(Method::getName).collect(Collectors.joining("\n\t", "\t", ""))));
        }
        if (methods.size() > 1) {
            throw new RuntimeException(String.format("More than one builder method found for configuration parameter name: %s", optionName));
        }
        Method method = (Method)methods.get(0);
        if (method.getParameterCount() != 1) {
            throw new RuntimeException(String.format("Method with unexpected parameter count %s found for configuration parameter name: %s", method.getParameterCount(), optionName));
        }
        return method;
    }

    public Object getRDFFormat(String rdfFormat) throws NoSuchFieldException, IllegalAccessException {
        return this.JenaRDFFormatClass.getDeclaredField(rdfFormat).get(this.JenaRDFFormatClass);
    }

    public Object parseToModel(String rawUnix, File file, Object lang) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object model = this.getModel();
        Object errorHandler = this.getErrorHandler(file);
        Object parser = this.getParser(lang, errorHandler, rawUnix);
        this.parseModel(parser, model);
        return model;
    }

    public boolean areModelsIsomorphic(Object leftModel, Object rightModel) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method isIsomorphicWith = this.JenaModelClass.getMethod("isIsomorphicWith", this.JenaModelClass);
        return (Boolean)isIsomorphicWith.invoke(leftModel, rightModel);
    }

    public long modelSize(Object model) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method size = this.JenaModelClass.getMethod("size", new Class[0]);
        return (Long)size.invoke(model, new Object[0]);
    }

    private static class SortedModelInvocationHandler
    implements InvocationHandler {
        private final ReflectionHelper reflectionHelper;
        private final Object jenaModel;

        public SortedModelInvocationHandler(ReflectionHelper reflectionHelper, Object jenaModel) {
            this.reflectionHelper = reflectionHelper;
            this.jenaModel = jenaModel;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("listSubjects") && method.getParameterCount() == 0) {
                Object resIterator = method.invoke(this.jenaModel, new Object[0]);
                ArrayList<Object> resources = new ArrayList<Object>();
                while (this.hasNext(resIterator)) {
                    resources.add(this.next(resIterator));
                }
                resources.sort(Comparator.comparing(x -> {
                    try {
                        return (String)x.getClass().getMethod("getURI", new Class[0]).invoke(x, new Object[0]);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }).thenComparing(x -> {
                    Object anonId;
                    try {
                        anonId = x.getClass().getMethod("getAnonId", new Class[0]).invoke(x, new Object[0]);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    if (anonId != null) {
                        return anonId.toString();
                    }
                    return null;
                }));
                return this.reflectionHelper.classLoader.loadClass("org.apache.jena.rdf.model.impl.ResIteratorImpl").getConstructor(Iterator.class, Object.class).newInstance(resources.iterator(), null);
            }
            return method.invoke(this.jenaModel, new Object[0]);
        }

        boolean hasNext(Object it) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            return (Boolean)it.getClass().getMethod("hasNext", new Class[0]).invoke(it, new Object[0]);
        }

        Object next(Object it) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            return it.getClass().getMethod("next", new Class[0]).invoke(it, new Object[0]);
        }
    }

    private class DynamicErrorInvocationHandler
    implements InvocationHandler {
        private final String filePath;

        public DynamicErrorInvocationHandler(File file) {
            this.filePath = ReflectionHelper.this.state.getConfig().isFailOnWarning() ? null : file.getPath();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String message = (String)args[0];
            long line = (Long)args[1];
            long col = (Long)args[2];
            String severity = method.getName();
            if (!severity.equals("warning") || ReflectionHelper.this.state.getConfig().isFailOnWarning()) {
                if (severity.equals("warning")) {
                    logger.error("Formatter fails because of a parser warning. To make the formatter succeed inthe presence of warnings, set the configuration parameter 'failOnWarning' to 'false' (default: 'true')");
                }
                throw new RuntimeException(String.format("line %d, col %d: %s (severity: %s)", line, col, message, severity));
            }
            logger.warn("{}({},{}): {}", new Object[]{this.filePath, line, col, message});
            return null;
        }
    }
}

