/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.pjf;

import com.diffplug.spotless.FormatterFunc;
import com.palantir.javaformat.java.Formatter;
import com.palantir.javaformat.java.ImportOrderer;
import com.palantir.javaformat.java.JavaFormatterOptions;
import com.palantir.javaformat.java.RemoveUnusedImports;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PalantirJavaFormatFormatterFunc
implements FormatterFunc {
    private final Formatter formatter;
    private final JavaFormatterOptions.Style formatterStyle;

    public PalantirJavaFormatFormatterFunc(String style, boolean formatJavadoc) {
        this.formatterStyle = JavaFormatterOptions.Style.valueOf((String)style);
        JavaFormatterOptions.Builder builder = JavaFormatterOptions.builder();
        builder.style(this.formatterStyle);
        if (formatJavadoc) {
            PalantirJavaFormatFormatterFunc.applyFormatJavadoc(builder);
        }
        this.formatter = Formatter.createFormatter((JavaFormatterOptions)builder.build());
    }

    @Override
    public String apply(String input) throws Exception {
        String source = input;
        source = ImportOrderer.reorderImports((String)source, (JavaFormatterOptions.Style)this.formatterStyle);
        source = RemoveUnusedImports.removeUnusedImports((String)source);
        return this.formatter.formatSource(source);
    }

    public String toString() {
        return "PalantirJavaFormatFormatterFunc{formatter=" + this.formatter + "}";
    }

    private static void applyFormatJavadoc(JavaFormatterOptions.Builder builder) {
        try {
            Method formatJavadoc = JavaFormatterOptions.Builder.class.getMethod("formatJavadoc", Boolean.TYPE);
            formatJavadoc.invoke((Object)builder, true);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Cannot enable formatJavadoc option, make sure you are using Palantir with version 2.36.0 or later", e);
        }
    }
}

