/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.Lint;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class FenceStep {
    String name;
    Pattern regex;

    public static FenceStep named(String name) {
        return new FenceStep(name);
    }

    public static String defaultToggleName() {
        return "toggle";
    }

    public static String defaultToggleOff() {
        return "spotless:off";
    }

    public static String defaultToggleOn() {
        return "spotless:on";
    }

    private FenceStep(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public FenceStep openClose(String open, String close) {
        return this.regex(Pattern.quote(open) + "([\\s\\S]*?)" + Pattern.quote(close));
    }

    public FenceStep regex(String regex) {
        return this.regex(Pattern.compile(regex));
    }

    public FenceStep regex(Pattern regex) {
        this.regex = Objects.requireNonNull(regex);
        return this;
    }

    private void assertRegexSet() {
        Objects.requireNonNull(this.regex, "must call regex() or openClose()");
    }

    public FormatterStep preserveWithin(List<FormatterStep> steps) {
        this.assertRegexSet();
        return new PreserveWithin(this.name, this.regex, steps);
    }

    public FormatterStep applyWithin(List<FormatterStep> steps) {
        this.assertRegexSet();
        return new ApplyWithin(this.name, this.regex, steps);
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private static abstract class BaseStep
    implements Serializable,
    FormatterStep {
        final String name;
        private static final long serialVersionUID = -2301848328356559915L;
        final Pattern regex;
        final List<FormatterStep> steps;
        transient ArrayList<String> groups = new ArrayList();
        transient StringBuilder builderInternal;
        private transient Formatter formatter;

        public BaseStep(String name, Pattern regex, List<FormatterStep> steps) {
            this.name = name;
            this.regex = regex;
            this.steps = steps;
        }

        protected ArrayList<String> groupsZeroed() {
            if (this.groups == null) {
                this.groups = new ArrayList();
            } else {
                this.groups.clear();
            }
            return this.groups;
        }

        private StringBuilder builderZeroed() {
            if (this.builderInternal == null) {
                this.builderInternal = new StringBuilder();
            } else {
                this.builderInternal.setLength(0);
            }
            return this.builderInternal;
        }

        protected Formatter buildFormatter() {
            return Formatter.builder().encoding(StandardCharsets.UTF_8).lineEndingsPolicy(LineEnding.UNIX.createPolicy()).steps(this.steps).build();
        }

        protected String assembleGroups(String unix) {
            if (this.groups.isEmpty()) {
                return unix;
            }
            StringBuilder builder = this.builderZeroed();
            Matcher matcher = this.regex.matcher(unix);
            int lastEnd = 0;
            int groupIdx = 0;
            while (matcher.find()) {
                builder.append(unix, lastEnd, matcher.start(1));
                builder.append(this.groups.get(groupIdx));
                lastEnd = matcher.end(1);
                ++groupIdx;
            }
            if (groupIdx == this.groups.size()) {
                builder.append(unix, lastEnd, unix.length());
                return builder.toString();
            }
            int startLine = 1 + (int)builder.toString().codePoints().filter(c -> c == 10).count();
            int endLine = 1 + (int)unix.codePoints().filter(c -> c == 10).count();
            Matcher openClose = Pattern.compile("\\\\Q([\\s\\S]*?)\\\\E\\Q([\\s\\S]*?)\\E\\\\Q([\\s\\S]*?)\\\\E").matcher(this.regex.pattern());
            Object pattern = openClose.matches() ? openClose.group(1) + " " + openClose.group(2) : this.regex.pattern();
            throw Lint.atLineRange(startLine, endLine, "fenceRemoved", "An intermediate step removed a match of " + (String)pattern).shortcut();
        }

        @Override
        public String getName() {
            return this.name;
        }

        private String apply(String rawUnix, File file) throws Exception {
            if (this.formatter == null) {
                this.formatter = this.buildFormatter();
            }
            return this.applySubclass(this.formatter, rawUnix, file);
        }

        @Override
        @Nullable
        public String format(String rawUnix, File file) throws Exception {
            return this.apply(rawUnix, file);
        }

        protected abstract String applySubclass(Formatter var1, String var2, File var3) throws Exception;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseStep step = (BaseStep)o;
            return this.name.equals(step.name) && this.regex.pattern().equals(step.regex.pattern()) && this.regex.flags() == step.regex.flags() && this.steps.equals(step.steps);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.regex.pattern(), this.regex.flags(), this.steps);
        }

        @Override
        public void close() {
            if (this.formatter != null) {
                this.formatter.close();
                this.formatter = null;
            }
        }
    }

    static class PreserveWithin
    extends BaseStep {
        private static final long serialVersionUID = -8676786492305178343L;

        PreserveWithin(String name, Pattern regex, List<FormatterStep> steps) {
            super(name, regex, steps);
        }

        private void storeGroups(String unix) {
            ArrayList<String> groups = this.groupsZeroed();
            Matcher matcher = this.regex.matcher(unix);
            while (matcher.find()) {
                groups.add(matcher.group(1));
            }
        }

        @Override
        protected String applySubclass(Formatter formatter, String unix, File file) {
            this.storeGroups(unix);
            String formatted = formatter.compute(unix, file);
            return this.assembleGroups(formatted);
        }
    }

    static class ApplyWithin
    extends BaseStep {
        private static final long serialVersionUID = 17061466531957339L;

        ApplyWithin(String name, Pattern regex, List<FormatterStep> steps) {
            super(name, regex, steps);
        }

        @Override
        protected String applySubclass(Formatter formatter, String unix, File file) {
            ArrayList<String> groups = this.groupsZeroed();
            Matcher matcher = this.regex.matcher(unix);
            while (matcher.find()) {
                groups.add(formatter.compute(matcher.group(1), file));
            }
            return this.assembleGroups(unix);
        }
    }
}

