/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.FormatterStepEqualityOnStateSerialization;
import com.diffplug.spotless.SerializedFunction;
import com.diffplug.spotless.ThrowingEx;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;

final class FormatterStepSerializationRoundtrip<RoundtripState extends Serializable, EqualityState extends Serializable>
extends FormatterStepEqualityOnStateSerialization<EqualityState> {
    private static final long serialVersionUID = 1L;
    private final String name;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="HackClone")
    private final transient ThrowingEx.Supplier<RoundtripState> initializer;
    @Nullable
    private RoundtripState roundtripStateInternal;
    @Nullable
    private EqualityState equalityStateInternal;
    private final SerializedFunction<RoundtripState, EqualityState> equalityStateExtractor;
    private final SerializedFunction<EqualityState, FormatterFunc> equalityStateToFormatter;

    FormatterStepSerializationRoundtrip(String name, ThrowingEx.Supplier<RoundtripState> initializer, SerializedFunction<RoundtripState, EqualityState> equalityStateExtractor, SerializedFunction<EqualityState, FormatterFunc> equalityStateToFormatter) {
        this.name = name;
        this.initializer = initializer;
        this.equalityStateExtractor = equalityStateExtractor;
        this.equalityStateToFormatter = equalityStateToFormatter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private RoundtripState roundtripStateSupplier() throws Exception {
        if (this.roundtripStateInternal == null) {
            this.roundtripStateInternal = (Serializable)this.initializer.get();
        }
        return this.roundtripStateInternal;
    }

    @Override
    protected EqualityState stateSupplier() throws Exception {
        if (this.equalityStateInternal == null) {
            this.equalityStateInternal = (Serializable)this.equalityStateExtractor.apply(this.roundtripStateSupplier());
        }
        return this.equalityStateInternal;
    }

    @Override
    protected FormatterFunc stateToFormatter(EqualityState equalityState) throws Exception {
        return (FormatterFunc)this.equalityStateToFormatter.apply(equalityState);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.initializer == null) {
            if (this.roundtripStateInternal == null && this.equalityStateInternal == null) {
                throw new IllegalStateException("If the initializer was null, then one of roundtripStateInternal or equalityStateInternal should be non-null, and neither was");
            }
        } else {
            if (this.roundtripStateInternal == null) {
                this.roundtripStateInternal = ThrowingEx.get(this::roundtripStateSupplier);
            }
            this.equalityStateInternal = null;
        }
        out.defaultWriteObject();
    }

    HackClone<?, ?> hackClone(boolean optimizeForEquality) {
        return new HackClone(this, optimizeForEquality);
    }

    static class HackClone<RoundtripState extends Serializable, EqualityState extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="HackClone")
        transient FormatterStepSerializationRoundtrip<?, ?> original;
        boolean optimizeForEquality;
        @Nullable
        FormatterStepSerializationRoundtrip cleaned;

        HackClone(@Nullable FormatterStepSerializationRoundtrip<RoundtripState, EqualityState> original, boolean optimizeForEquality) {
            this.original = original;
            this.optimizeForEquality = optimizeForEquality;
        }

        @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="HackClone")
        private void writeObject(ObjectOutputStream out) throws IOException {
            if (this.cleaned == null) {
                this.cleaned = new FormatterStepSerializationRoundtrip(this.original.name, null, this.original.equalityStateExtractor, this.original.equalityStateToFormatter);
                if (this.optimizeForEquality) {
                    this.cleaned.equalityStateInternal = ThrowingEx.get(this.original::stateSupplier);
                } else {
                    this.cleaned.roundtripStateInternal = ThrowingEx.get(() -> this.original.roundtripStateSupplier());
                }
            }
            out.defaultWriteObject();
        }

        public FormatterStep rehydrate() {
            return this.original != null ? this.original : (FormatterStep)Objects.requireNonNull(this.cleaned, "how is clean null if this has been serialized?");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HackClone that = (HackClone)o;
            return this.optimizeForEquality == that.optimizeForEquality && this.rehydrate().equals(that.rehydrate());
        }

        public int hashCode() {
            return this.rehydrate().hashCode() ^ Boolean.hashCode(this.optimizeForEquality);
        }
    }
}

