/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.FormatterStepSerializationRoundtrip;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ConfigurationCacheHackList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean optimizeForEquality;
    private final ArrayList<Object> backingList = new ArrayList();

    public static ConfigurationCacheHackList forEquality() {
        return new ConfigurationCacheHackList(true);
    }

    public static ConfigurationCacheHackList forRoundtrip() {
        return new ConfigurationCacheHackList(false);
    }

    private ConfigurationCacheHackList(boolean optimizeForEquality) {
        this.optimizeForEquality = optimizeForEquality;
    }

    public void clear() {
        this.backingList.clear();
    }

    public void addAll(Collection<? extends FormatterStep> c) {
        for (FormatterStep formatterStep : c) {
            if (formatterStep instanceof FormatterStepSerializationRoundtrip) {
                FormatterStepSerializationRoundtrip.HackClone<?, ?> clone = ((FormatterStepSerializationRoundtrip)formatterStep).hackClone(this.optimizeForEquality);
                this.backingList.add(clone);
                continue;
            }
            this.backingList.add(formatterStep);
        }
    }

    public List<FormatterStep> getSteps() {
        ArrayList<FormatterStep> result = new ArrayList<FormatterStep>(this.backingList.size());
        for (Object obj : this.backingList) {
            if (obj instanceof FormatterStepSerializationRoundtrip.HackClone) {
                result.add(((FormatterStepSerializationRoundtrip.HackClone)obj).rehydrate());
                continue;
            }
            result.add((FormatterStep)obj);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationCacheHackList stepList = (ConfigurationCacheHackList)o;
        return this.optimizeForEquality == stepList.optimizeForEquality && this.backingList.equals(stepList.backingList);
    }

    public int hashCode() {
        return Objects.hash(this.optimizeForEquality, this.backingList);
    }
}

