/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.FormatterStep;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PipeStepPair {
    final FormatterStep in;
    final FormatterStep out;

    public static Builder named(String name) {
        return new Builder(name);
    }

    public static String defaultToggleName() {
        return "toggle";
    }

    public static String defaultToggleOff() {
        return "spotless:off";
    }

    public static String defaultToggleOn() {
        return "spotless:on";
    }

    private PipeStepPair(String name, Pattern pattern) {
        StateIn stateIn = new StateIn(pattern);
        StateOut stateOut = new StateOut(stateIn);
        this.in = FormatterStep.create(name + "In", stateIn, state -> x$0 -> ((StateIn)state).format(x$0));
        this.out = FormatterStep.create(name + "Out", stateOut, state -> x$0 -> ((StateOut)state).format(x$0));
    }

    public FormatterStep in() {
        return this.in;
    }

    public FormatterStep out() {
        return this.out;
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class StateOut
    implements Serializable {
        private static final long serialVersionUID = -1195263184715054229L;
        final StateIn in;
        final transient StringBuilder builder = new StringBuilder();

        StateOut(StateIn in) {
            this.in = in;
        }

        private String format(String unix) {
            if (this.in.groups.isEmpty()) {
                return unix;
            }
            this.builder.setLength(0);
            Matcher matcher = this.in.regex.matcher(unix);
            int lastEnd = 0;
            int groupIdx = 0;
            while (matcher.find()) {
                this.builder.append(unix, lastEnd, matcher.start(1));
                this.builder.append(this.in.groups.get(groupIdx));
                lastEnd = matcher.end(1);
                ++groupIdx;
            }
            if (groupIdx == this.in.groups.size()) {
                this.builder.append(unix, lastEnd, unix.length());
                return this.builder.toString();
            }
            Matcher openClose = Pattern.compile("\\\\Q([\\s\\S]*?)\\\\E\\Q([\\s\\S]*?)\\E\\\\Q([\\s\\S]*?)\\\\E").matcher(this.in.regex.pattern());
            String pattern = openClose.matches() ? openClose.group(1) + " " + openClose.group(2) : this.in.regex.pattern();
            throw new Error("An intermediate step removed a match of " + pattern);
        }
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class StateIn
    implements Serializable {
        private static final long serialVersionUID = -844178006407733370L;
        final Pattern regex;
        final transient ArrayList<String> groups = new ArrayList();

        public StateIn(Pattern regex) {
            this.regex = regex;
        }

        private String format(String unix) {
            this.groups.clear();
            Matcher matcher = this.regex.matcher(unix);
            while (matcher.find()) {
                this.groups.add(matcher.group(1));
            }
            return unix;
        }
    }

    public static class Builder {
        String name;
        Pattern regex;

        private Builder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public Builder openClose(String open, String close) {
            return this.regex(Pattern.quote(open) + "([\\s\\S]*?)" + Pattern.quote(close));
        }

        public Builder regex(String regex) {
            return this.regex(Pattern.compile(regex));
        }

        public Builder regex(Pattern regex) {
            this.regex = regex;
            return this;
        }

        public PipeStepPair buildPair() {
            return new PipeStepPair(this.name, this.regex);
        }
    }
}

