/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.pom;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.pom.SortPomCfg;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sortpom.SortPomImpl;
import sortpom.logger.SortPomLogger;
import sortpom.parameter.PluginParameters;

public class SortPomFormatterFunc
implements FormatterFunc {
    private static final Logger logger = LoggerFactory.getLogger(SortPomFormatterFunc.class);
    private final SortPomCfg cfg;

    public SortPomFormatterFunc(SortPomCfg cfg) {
        this.cfg = cfg;
    }

    @Override
    public String apply(String input) throws Exception {
        File pom = File.createTempFile("pom", ".xml");
        pom.deleteOnExit();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(pom, Charset.forName(this.cfg.encoding)));){
            writer.write(input);
        }
        SortPomImpl sortPom = new SortPomImpl();
        sortPom.setup((SortPomLogger)new MySortPomLogger(), PluginParameters.builder().setPomFile(pom).setFileOutput(false, null, null, false).setEncoding(this.cfg.encoding).setFormatting(this.cfg.lineSeparator, this.cfg.expandEmptyElements, this.cfg.spaceBeforeCloseEmptyElement, this.cfg.keepBlankLines).setIndent(this.cfg.nrOfIndentSpace, this.cfg.indentBlankLines, this.cfg.indentSchemaLocation).setSortOrder(this.cfg.sortOrderFile, this.cfg.predefinedSortOrder).setSortEntities(this.cfg.sortDependencies, this.cfg.sortDependencyExclusions, this.cfg.sortDependencyManagement, this.cfg.sortPlugins, this.cfg.sortProperties, this.cfg.sortModules, this.cfg.sortExecutions).setIgnoreLineSeparators(false).build());
        sortPom.sortPom();
        return Files.readString(pom.toPath(), Charset.forName(this.cfg.encoding));
    }

    private static class MySortPomLogger
    implements SortPomLogger {
        private MySortPomLogger() {
        }

        public void warn(String content) {
            logger.warn(content);
        }

        public void info(String content) {
            logger.info(content);
        }

        public void error(String content) {
            logger.error(content);
        }
    }
}

