/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.yaml;

import com.diffplug.spotless.glue.json.AJacksonFormatterFunc;
import com.diffplug.spotless.yaml.JacksonYamlConfig;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactoryBuilder;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;

public class JacksonYamlFormatterFunc
extends AJacksonFormatterFunc {
    final JacksonYamlConfig yamlConfig;

    public JacksonYamlFormatterFunc(JacksonYamlConfig jacksonConfig) {
        super(jacksonConfig);
        this.yamlConfig = jacksonConfig;
        if (jacksonConfig == null) {
            throw new IllegalArgumentException("ARG");
        }
    }

    @Override
    protected JsonFactory makeJsonFactory() {
        YAMLFactoryBuilder yamlFactoryBuilder = new YAMLFactoryBuilder(new YAMLFactory());
        this.yamlConfig.getYamlFeatureToToggle().forEach((rawFeature, toggle) -> {
            YAMLGenerator.Feature feature = YAMLGenerator.Feature.valueOf((String)rawFeature);
            yamlFactoryBuilder.configure(feature, toggle.booleanValue());
        });
        return yamlFactoryBuilder.build();
    }

    @Override
    protected String format(ObjectMapper objectMapper, String input) throws IllegalArgumentException, IOException {
        try {
            JsonParser yamlParser = objectMapper.getFactory().createParser(input);
            List documents = objectMapper.readValues(yamlParser, JsonNode.class).readAll();
            StringWriter stringWriter = new StringWriter();
            objectMapper.writer().writeValues((Writer)stringWriter).writeAll((Collection)documents).close();
            return stringWriter.toString();
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to format. input='" + input + "'", e);
        }
    }
}

