/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.ThrowingEx;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.Objects;
import javax.annotation.Nullable;

class FeatureClassLoader
extends URLClassLoader {
    private final ClassLoader buildToolClassLoader;

    FeatureClassLoader(URL[] urls, ClassLoader buildToolClassLoader) {
        super(urls, FeatureClassLoader.getParentClassLoader());
        Objects.requireNonNull(buildToolClassLoader);
        this.buildToolClassLoader = buildToolClassLoader;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("com.diffplug.spotless.glue.")) {
            String path = name.replace('.', '/') + ".class";
            URL url = this.findResource(path);
            if (url == null) {
                throw new ClassNotFoundException(name);
            }
            try {
                return this.defineClass(name, FeatureClassLoader.urlToByteBuffer(url), (ProtectionDomain)null);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name, e);
            }
        }
        if (FeatureClassLoader.useBuildToolClassLoader(name)) {
            return this.buildToolClassLoader.loadClass(name);
        }
        return super.findClass(name);
    }

    private static boolean useBuildToolClassLoader(String name) {
        if (name.startsWith("org.slf4j.")) {
            return true;
        }
        return !name.startsWith("com.diffplug.spotless.extra") && name.startsWith("com.diffplug.spotless.");
    }

    @Override
    public URL findResource(String name) {
        URL resource = super.findResource(name);
        if (resource != null) {
            return resource;
        }
        return this.buildToolClassLoader.getResource(name);
    }

    private static ByteBuffer urlToByteBuffer(URL url) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        InputStream inputStream = url.openStream();
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return ByteBuffer.wrap(buffer.toByteArray());
    }

    @Nullable
    private static ClassLoader getParentClassLoader() {
        double version = Double.parseDouble(System.getProperty("java.specification.version"));
        if (version > 1.8) {
            try {
                return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw ThrowingEx.asRuntime(e);
            }
        }
        return null;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

