/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.kotlin.BadSemver;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class KtLintStep {
    private static final String DEFAULT_VERSION = "0.48.1";
    static final String NAME = "ktlint";
    static final String PACKAGE_PRE_0_32 = "com.github.shyiko";
    static final String PACKAGE = "com.pinterest";
    static final String MAVEN_COORDINATE_PRE_0_32 = "com.github.shyiko:ktlint:";
    static final String MAVEN_COORDINATE = "com.pinterest:ktlint:";

    private KtLintStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return KtLintStep.create(KtLintStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return KtLintStep.create(version, provisioner, false, Collections.emptyMap(), Collections.emptyMap());
    }

    public static FormatterStep create(String version, Provisioner provisioner, boolean useExperimental, Map<String, String> userData, Map<String, Object> editorConfigOverride) {
        return KtLintStep.create(version, provisioner, false, useExperimental, null, userData, editorConfigOverride);
    }

    public static FormatterStep createForScript(String version, Provisioner provisioner) {
        return KtLintStep.create(version, provisioner, true, false, null, Collections.emptyMap(), Collections.emptyMap());
    }

    public static FormatterStep createForScript(String version, Provisioner provisioner, boolean useExperimental, @Nullable FileSignature editorConfigPath, Map<String, String> userData, Map<String, Object> editorConfigOverride) {
        return KtLintStep.create(version, provisioner, true, useExperimental, editorConfigPath, userData, editorConfigOverride);
    }

    public static FormatterStep create(String version, Provisioner provisioner, boolean isScript, boolean useExperimental, @Nullable FileSignature editorConfig, Map<String, String> userData, Map<String, Object> editorConfigOverride) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(version, provisioner, isScript, useExperimental, editorConfig, userData, editorConfigOverride), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean isScript;
        final JarState jarState;
        private final boolean useExperimental;
        private final TreeMap<String, String> userData;
        private final TreeMap<String, Object> editorConfigOverride;
        private final String version;
        @Nullable
        private final FileSignature editorConfigPath;

        State(String version, Provisioner provisioner, boolean isScript, boolean useExperimental, @Nullable FileSignature editorConfigPath, Map<String, String> userData, Map<String, Object> editorConfigOverride) throws IOException {
            this.version = version;
            String coordinate = BadSemver.version(version) < BadSemver.version(0, 32) ? KtLintStep.MAVEN_COORDINATE_PRE_0_32 : KtLintStep.MAVEN_COORDINATE;
            if (BadSemver.version(version) < BadSemver.version(0, 31, 0)) {
                throw new IllegalStateException("KtLint versions < 0.31.0 not supported!");
            }
            this.useExperimental = useExperimental;
            this.userData = new TreeMap<String, String>(userData);
            this.editorConfigOverride = new TreeMap<String, Object>(editorConfigOverride);
            this.jarState = JarState.from(coordinate + version, provisioner);
            this.editorConfigPath = editorConfigPath;
            this.isScript = isScript;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterFunc = classLoader.loadClass("com.diffplug.spotless.glue.ktlint.KtlintFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(String.class, Boolean.TYPE, Boolean.TYPE, FileSignature.class, Map.class, Map.class);
            return (FormatterFunc.NeedsFile)constructor.newInstance(this.version, this.isScript, this.useExperimental, this.editorConfigPath, this.userData, this.editorConfigOverride);
        }
    }
}

