/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.yaml;

import com.diffplug.spotless.FormatterFunc;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.util.List;

public class YamlJacksonFormatterFunc
implements FormatterFunc {
    private List<String> enabledFeatures;
    private List<String> disabledFeatures;

    public YamlJacksonFormatterFunc(List<String> enabledFeatures, List<String> disabledFeatures) {
        this.enabledFeatures = enabledFeatures;
        this.disabledFeatures = disabledFeatures;
    }

    @Override
    public String apply(String input) throws Exception {
        ObjectMapper objectMapper = this.makeObjectMapper();
        return this.format(objectMapper, input);
    }

    protected ObjectMapper makeObjectMapper() {
        SerializationFeature feature;
        YAMLFactory yamlFactory = new YAMLFactory();
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)yamlFactory);
        for (String rawFeature : this.enabledFeatures) {
            feature = SerializationFeature.valueOf((String)rawFeature);
            objectMapper.enable(feature);
        }
        for (String rawFeature : this.disabledFeatures) {
            feature = SerializationFeature.valueOf((String)rawFeature);
            objectMapper.disable(feature);
        }
        return objectMapper;
    }

    protected String format(ObjectMapper objectMapper, String input) throws IllegalArgumentException, IOException {
        try {
            ObjectNode objectNode = (ObjectNode)objectMapper.readValue(input, ObjectNode.class);
            return objectMapper.writeValueAsString((Object)objectNode);
        }
        catch (JsonProcessingException e) {
            throw new AssertionError("Unable to format YAML. input='" + input + "'", e);
        }
    }

    private static class ObjectNodeTypeReference
    extends TypeReference<ObjectNode> {
        private ObjectNodeTypeReference() {
        }
    }
}

