/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.DelegateFormatterStep;
import com.diffplug.spotless.NoLambda;
import com.diffplug.spotless.ThrowingEx;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class LazyForwardingEquality<T extends Serializable>
implements Serializable,
NoLambda {
    private static final long serialVersionUID = 1L;
    @Nullable
    private volatile transient T state;

    protected abstract T calculateState() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T state() {
        if (this.state == null) {
            LazyForwardingEquality lazyForwardingEquality = this;
            synchronized (lazyForwardingEquality) {
                if (this.state == null) {
                    try {
                        this.state = this.calculateState();
                    }
                    catch (Exception e) {
                        throw ThrowingEx.asRuntime(e);
                    }
                }
            }
        }
        return this.state;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.state());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.state = (Serializable)Objects.requireNonNull(in.readObject());
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] toBytes() {
        return LazyForwardingEquality.toBytes(this.state());
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass().equals(other.getClass())) {
            LazyForwardingEquality otherCast = (LazyForwardingEquality)other;
            return Arrays.equals(otherCast.toBytes(), this.toBytes());
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.toBytes());
    }

    static byte[] toBytes(Serializable obj) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutput = new ObjectOutputStream(byteOutput);){
            objectOutput.writeObject(obj);
        }
        catch (IOException e) {
            throw ThrowingEx.asRuntime(e);
        }
        return byteOutput.toByteArray();
    }

    public static void unlazy(Object in) {
        if (in instanceof LazyForwardingEquality) {
            ((LazyForwardingEquality)in).state();
        } else if (in instanceof DelegateFormatterStep) {
            LazyForwardingEquality.unlazy(((DelegateFormatterStep)in).delegateStep);
        } else if (in instanceof Iterable) {
            Iterable cast = (Iterable)in;
            for (Object c : cast) {
                LazyForwardingEquality.unlazy(c);
            }
        }
    }
}

