/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.glue.jdt;

import com.diffplug.spotless.extra.glue.jdt.JdtFlags;
import com.diffplug.spotless.extra.glue.jdt.SuppressFBWarnings;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.dom.NaiveASTFlattener;

@SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="this comparator is not meant to be serialized")
class DefaultJavaElementComparator
implements Comparator<BodyDeclaration> {
    static final int TYPE_INDEX = 0;
    static final int CONSTRUCTORS_INDEX = 1;
    static final int METHOD_INDEX = 2;
    static final int FIELDS_INDEX = 3;
    static final int INIT_INDEX = 4;
    static final int STATIC_FIELDS_INDEX = 5;
    static final int STATIC_INIT_INDEX = 6;
    static final int STATIC_METHODS_INDEX = 7;
    static final int ENUM_CONSTANTS_INDEX = 8;
    static final int N_CATEGORIES = 9;
    static final int PUBLIC_INDEX = 0;
    static final int PRIVATE_INDEX = 1;
    static final int PROTECTED_INDEX = 2;
    static final int DEFAULT_INDEX = 3;
    static final int N_VISIBILITIES = 4;
    private final boolean doNotSortFields;
    private final int[] memberCategoryOffsets;
    private final boolean sortByVisibility;
    private final int[] visibilityOffsets;

    static DefaultJavaElementComparator of(boolean doNotSortFields, String memberCategoryPreferences, boolean sortByVisibility, String visibilityPreferences) {
        int[] visibilityOffsets;
        boolean success2;
        int[] memberCategoryOffsets = new int[9];
        boolean success = DefaultJavaElementComparator.fillMemberCategoryOffsets(memberCategoryPreferences, memberCategoryOffsets);
        if (!success) {
            String defaultValue = "T,SF,SI,SM,F,I,C,M";
            DefaultJavaElementComparator.fillMemberCategoryOffsets(defaultValue, memberCategoryOffsets);
        }
        if (!(success2 = DefaultJavaElementComparator.fillVisibilityOffsets(visibilityPreferences, visibilityOffsets = new int[4]))) {
            String defaultValue = "B,V,R,D";
            DefaultJavaElementComparator.fillVisibilityOffsets(defaultValue, visibilityOffsets);
        }
        return new DefaultJavaElementComparator(doNotSortFields, memberCategoryOffsets, sortByVisibility, visibilityOffsets);
    }

    DefaultJavaElementComparator(boolean doNotSortFields, int[] memberCategoryOffsets, boolean sortByVisibility, int[] visibilityOffsets) {
        this.doNotSortFields = doNotSortFields;
        this.memberCategoryOffsets = memberCategoryOffsets;
        this.sortByVisibility = sortByVisibility;
        this.visibilityOffsets = visibilityOffsets;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="we only accept valid tokens in the order string, otherwise we fall back to default value")
    static boolean fillVisibilityOffsets(String preferencesString, int[] offsets) {
        StringTokenizer tokenizer = new StringTokenizer(preferencesString, ",");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token;
            switch (token = tokenizer.nextToken()) {
                case "B": {
                    offsets[0] = i++;
                    break;
                }
                case "D": {
                    offsets[3] = i++;
                    break;
                }
                case "R": {
                    offsets[2] = i++;
                    break;
                }
                case "V": {
                    offsets[1] = i++;
                }
            }
        }
        return i == 4;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="we only accept valid tokens in the order string, otherwise we fall back to default value")
    static boolean fillMemberCategoryOffsets(String orderString, int[] offsets) {
        StringTokenizer tokenizer = new StringTokenizer(orderString, ",");
        int i = 0;
        offsets[8] = i++;
        while (tokenizer.hasMoreTokens()) {
            String token;
            switch (token = tokenizer.nextToken()) {
                case "C": {
                    offsets[1] = i++;
                    break;
                }
                case "F": {
                    offsets[3] = i++;
                    break;
                }
                case "I": {
                    offsets[4] = i++;
                    break;
                }
                case "M": {
                    offsets[2] = i++;
                    break;
                }
                case "T": {
                    offsets[0] = i++;
                    break;
                }
                case "SF": {
                    offsets[5] = i++;
                    break;
                }
                case "SI": {
                    offsets[6] = i++;
                    break;
                }
                case "SM": {
                    offsets[7] = i++;
                }
            }
        }
        return i == 9;
    }

    private int category(BodyDeclaration bodyDeclaration) {
        switch (bodyDeclaration.getNodeType()) {
            case 31: {
                MethodDeclaration method = (MethodDeclaration)bodyDeclaration;
                if (method.isConstructor()) {
                    return 1;
                }
                int flags = method.getModifiers();
                if (Modifier.isStatic((int)flags)) {
                    return 7;
                }
                return 2;
            }
            case 23: {
                if (JdtFlags.isStatic(bodyDeclaration)) {
                    return 5;
                }
                return 3;
            }
            case 28: {
                int flags = bodyDeclaration.getModifiers();
                if (Modifier.isStatic((int)flags)) {
                    return 6;
                }
                return 4;
            }
            case 55: 
            case 71: 
            case 81: {
                return 0;
            }
            case 72: {
                return 8;
            }
            case 82: {
                return 2;
            }
        }
        return 0;
    }

    private int getCategoryIndex(int category) {
        return this.memberCategoryOffsets[category];
    }

    private int getVisibilityIndex(int modifierFlags) {
        int kind = 3;
        if (Flags.isPublic((int)modifierFlags)) {
            kind = 0;
        } else if (Flags.isProtected((int)modifierFlags)) {
            kind = 2;
        } else if (Flags.isPrivate((int)modifierFlags)) {
            kind = 1;
        }
        return this.visibilityOffsets[kind];
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="when switching to a more recent Java version, we can avoid those unconfirmed casts")
    public int compare(BodyDeclaration bodyDeclaration1, BodyDeclaration bodyDeclaration2) {
        int vis;
        boolean preserved1 = this.doNotSortFields && this.isSortPreserved(bodyDeclaration1);
        boolean preserved2 = this.doNotSortFields && this.isSortPreserved(bodyDeclaration2);
        int cat1 = this.category(bodyDeclaration1);
        if (preserved1) {
            cat1 = DefaultJavaElementComparator.sortPreservedCategory(cat1);
        }
        int cat2 = this.category(bodyDeclaration2);
        if (preserved2) {
            cat2 = DefaultJavaElementComparator.sortPreservedCategory(cat2);
        }
        if (cat1 != cat2) {
            return this.getCategoryIndex(cat1) - this.getCategoryIndex(cat2);
        }
        if (preserved1) {
            return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
        }
        if (this.sortByVisibility) {
            int flags1 = JdtFlags.getVisibilityCode(bodyDeclaration1);
            int flags2 = JdtFlags.getVisibilityCode(bodyDeclaration2);
            vis = this.getVisibilityIndex(flags1) - this.getVisibilityIndex(flags2);
            if (vis != 0) {
                return vis;
            }
        }
        switch (bodyDeclaration1.getNodeType()) {
            case 31: {
                String name2;
                MethodDeclaration method1 = (MethodDeclaration)bodyDeclaration1;
                MethodDeclaration method2 = (MethodDeclaration)bodyDeclaration2;
                if (this.sortByVisibility && (vis = this.getVisibilityIndex(method1.getModifiers()) - this.getVisibilityIndex(method2.getModifiers())) != 0) {
                    return vis;
                }
                String name1 = method1.getName().getIdentifier();
                int cmp = name1.compareTo(name2 = method2.getName().getIdentifier());
                if (cmp != 0) {
                    return cmp;
                }
                List parameters1 = method1.parameters();
                List parameters2 = method2.parameters();
                int length1 = parameters1.size();
                int length2 = parameters2.size();
                int len = Math.min(length1, length2);
                for (int i = 0; i < len; ++i) {
                    SingleVariableDeclaration param1 = (SingleVariableDeclaration)parameters1.get(i);
                    SingleVariableDeclaration param2 = (SingleVariableDeclaration)parameters2.get(i);
                    cmp = this.buildSignature(param1.getType()).compareTo(this.buildSignature(param2.getType()));
                    if (cmp == 0) continue;
                    return cmp;
                }
                if (length1 != length2) {
                    return length1 - length2;
                }
                return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
            }
            case 23: {
                FieldDeclaration field1 = (FieldDeclaration)bodyDeclaration1;
                FieldDeclaration field2 = (FieldDeclaration)bodyDeclaration2;
                String name1 = ((VariableDeclarationFragment)field1.fragments().get(0)).getName().getIdentifier();
                String name2 = ((VariableDeclarationFragment)field2.fragments().get(0)).getName().getIdentifier();
                return this.compareNames(bodyDeclaration1, bodyDeclaration2, name1, name2);
            }
            case 28: {
                return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
            }
            case 55: 
            case 71: 
            case 81: {
                AbstractTypeDeclaration type1 = (AbstractTypeDeclaration)bodyDeclaration1;
                AbstractTypeDeclaration type2 = (AbstractTypeDeclaration)bodyDeclaration2;
                String name1 = type1.getName().getIdentifier();
                String name2 = type2.getName().getIdentifier();
                return this.compareNames(bodyDeclaration1, bodyDeclaration2, name1, name2);
            }
            case 72: {
                EnumConstantDeclaration decl1 = (EnumConstantDeclaration)bodyDeclaration1;
                EnumConstantDeclaration decl2 = (EnumConstantDeclaration)bodyDeclaration2;
                String name1 = decl1.getName().getIdentifier();
                String name2 = decl2.getName().getIdentifier();
                return this.compareNames(bodyDeclaration1, bodyDeclaration2, name1, name2);
            }
            case 82: {
                AnnotationTypeMemberDeclaration decl1 = (AnnotationTypeMemberDeclaration)bodyDeclaration1;
                AnnotationTypeMemberDeclaration decl2 = (AnnotationTypeMemberDeclaration)bodyDeclaration2;
                String name1 = decl1.getName().getIdentifier();
                String name2 = decl2.getName().getIdentifier();
                return this.compareNames(bodyDeclaration1, bodyDeclaration2, name1, name2);
            }
        }
        return 0;
    }

    private static int sortPreservedCategory(int category) {
        switch (category) {
            case 5: 
            case 6: {
                return 5;
            }
            case 3: 
            case 4: {
                return 3;
            }
        }
        return category;
    }

    private boolean isSortPreserved(BodyDeclaration bodyDeclaration) {
        switch (bodyDeclaration.getNodeType()) {
            case 23: 
            case 28: 
            case 72: {
                return true;
            }
        }
        return false;
    }

    private int preserveRelativeOrder(BodyDeclaration bodyDeclaration1, BodyDeclaration bodyDeclaration2) {
        int value1 = (Integer)bodyDeclaration1.getProperty("relativeOrder");
        int value2 = (Integer)bodyDeclaration2.getProperty("relativeOrder");
        return value1 - value2;
    }

    private int compareNames(BodyDeclaration bodyDeclaration1, BodyDeclaration bodyDeclaration2, String name1, String name2) {
        int cmp = name1.compareTo(name2);
        if (cmp != 0) {
            return cmp;
        }
        return this.preserveRelativeOrder(bodyDeclaration1, bodyDeclaration2);
    }

    private String buildSignature(Type type) {
        NaiveASTFlattener flattener = new NaiveASTFlattener();
        type.accept((ASTVisitor)flattener);
        return flattener.getResult();
    }
}

