/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.cpp;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.extra.EquoBasedStepBuilder;
import dev.equo.solstice.p2.P2Model;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public final class EclipseCdtFormatterStep {
    private static final String NAME = "eclipse cdt formatter";
    private static final Jvm.Support<String> JVM_SUPPORT = Jvm.support((String)"eclipse cdt formatter").add(11, (Object)"10.7").add(17, (Object)"11.1");

    private EclipseCdtFormatterStep() {
    }

    public static String defaultVersion() {
        return (String)JVM_SUPPORT.getRecommendedFormatterVersion();
    }

    public static EquoBasedStepBuilder createBuilder(Provisioner provisioner) {
        return new EquoBasedStepBuilder(NAME, provisioner, EclipseCdtFormatterStep.defaultVersion(), EclipseCdtFormatterStep::apply){

            @Override
            protected P2Model model(String version) {
                P2Model model = new P2Model();
                this.addPlatformRepo(model, "4.26");
                model.addP2Repo("https://download.eclipse.org/tools/cdt/releases/" + version + "/");
                model.getInstall().add("org.eclipse.cdt.core");
                return model;
            }
        };
    }

    private static FormatterFunc apply(EquoBasedStepBuilder.State state) throws Exception {
        JVM_SUPPORT.assertFormatterSupported((Object)state.getSemanticVersion());
        Class<?> formatterClazz = state.getJarState().getClassLoader().loadClass("com.diffplug.spotless.extra.glue.cdt.EclipseCdtFormatterStepImpl");
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod("format", String.class);
        return JVM_SUPPORT.suggestLaterVersionOnError((Object)state.getSemanticVersion(), input -> {
            try {
                return (String)method.invoke(formatter, input);
            }
            catch (InvocationTargetException exceptionWrapper) {
                Throwable throwable = exceptionWrapper.getTargetException();
                Exception exception = throwable instanceof Exception ? (Exception)throwable : null;
                throw null == exception ? exceptionWrapper : exception;
            }
        });
    }
}

