/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterProperties;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import dev.equo.solstice.NestedJars;
import dev.equo.solstice.p2.P2ClientCache;
import dev.equo.solstice.p2.P2Model;
import dev.equo.solstice.p2.P2QueryCache;
import dev.equo.solstice.p2.P2QueryResult;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;

public abstract class EquoBasedStepBuilder {
    private final String formatterName;
    private final Provisioner mavenProvisioner;
    private final ThrowingEx.Function<State, FormatterFunc> stateToFormatter;
    private String formatterVersion;
    private Iterable<File> settingsFiles = new ArrayList<File>();
    private Map<String, String> p2Mirrors = Map.of();

    @Deprecated
    public EquoBasedStepBuilder(String formatterName, Provisioner mavenProvisioner, ThrowingEx.Function<State, FormatterFunc> stateToFormatter) {
        this(formatterName, mavenProvisioner, null, stateToFormatter);
    }

    public EquoBasedStepBuilder(String formatterName, Provisioner mavenProvisioner, @Nullable String defaultVersion, ThrowingEx.Function<State, FormatterFunc> stateToFormatter) {
        this.formatterName = formatterName;
        this.mavenProvisioner = mavenProvisioner;
        this.formatterVersion = defaultVersion;
        this.stateToFormatter = stateToFormatter;
    }

    public void setVersion(String version) {
        this.formatterVersion = version;
    }

    public void setPreferences(Iterable<File> settingsFiles) {
        this.settingsFiles = settingsFiles;
    }

    public void setP2Mirrors(Map<String, String> p2Mirrors) {
        this.p2Mirrors = Map.copyOf(p2Mirrors);
    }

    public FormatterStep build() {
        return FormatterStep.createLazy((String)this.formatterName, this::get, this.stateToFormatter);
    }

    protected abstract P2Model model(String var1);

    protected void addPlatformRepo(P2Model model, String version) {
        if (!version.startsWith("4.")) {
            throw new IllegalArgumentException("Expected 4.x");
        }
        int minorVersion = Integer.parseInt(version.substring("4.".length()));
        model.addP2Repo("https://download.eclipse.org/eclipse/updates/" + version + "/");
        model.getInstall().addAll(List.of("org.apache.felix.scr", "org.eclipse.equinox.event"));
        if (minorVersion >= 25) {
            model.getInstall().addAll(List.of("org.osgi.service.cm", "org.osgi.service.metatype"));
        }
    }

    State get() throws Exception {
        P2QueryResult query;
        try {
            query = this.createModelWithMirrors().query(P2ClientCache.PREFER_OFFLINE, P2QueryCache.ALLOW);
        }
        catch (Exception x) {
            throw new IOException("Failed to load " + this.formatterName + ": " + x, x);
        }
        ArrayList<File> classpath = new ArrayList<File>();
        ArrayList<String> mavenDeps = new ArrayList<String>();
        mavenDeps.add("dev.equo.ide:solstice:1.3.1");
        mavenDeps.add("com.diffplug.durian:durian-swt.os:4.2.0");
        mavenDeps.addAll(query.getJarsOnMavenCentral());
        classpath.addAll(this.mavenProvisioner.provisionWithTransitives(false, mavenDeps));
        classpath.addAll(query.getJarsNotOnMavenCentral());
        for (Map.Entry nested : NestedJars.inFiles((Iterable)query.getJarsNotOnMavenCentral()).extractAllNestedJars()) {
            classpath.add((File)nested.getValue());
        }
        JarState jarState = JarState.preserveOrder(classpath);
        return new State(this.formatterVersion, jarState, FileSignature.signAsList(this.settingsFiles));
    }

    private P2Model createModelWithMirrors() {
        P2Model model = this.model(this.formatterVersion);
        if (this.p2Mirrors.isEmpty()) {
            return model;
        }
        ArrayList p2Repos = new ArrayList(model.getP2repo());
        p2Repos.replaceAll(url -> {
            for (Map.Entry<String, String> mirror : this.p2Mirrors.entrySet()) {
                String prefix = mirror.getKey();
                if (!url.startsWith(prefix)) continue;
                return mirror.getValue() + url.substring(prefix.length());
            }
            throw new IllegalStateException("no mirror configured for P2 repository: " + url);
        });
        model.getP2repo().clear();
        model.getP2repo().addAll(p2Repos);
        return model;
    }

    public static class State
    implements Serializable {
        private static final long serialVersionUID = 584400372246020995L;
        final String semanticVersion;
        final JarState jarState;
        final FileSignature settingsFiles;

        public State(String semanticVersion, JarState jarState, FileSignature settingsFiles) {
            this.semanticVersion = semanticVersion;
            this.jarState = jarState;
            this.settingsFiles = settingsFiles;
        }

        public JarState getJarState() {
            return this.jarState;
        }

        public String getSemanticVersion() {
            return this.semanticVersion;
        }

        public Properties getPreferences() {
            return FormatterProperties.from((Iterable)this.settingsFiles.files()).getProperties();
        }
    }
}

