/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.java;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseFramework;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.osgi.framework.BundleActivator;

public class EclipseJdtFormatterStepImpl {
    private final CodeFormatter codeFormatter;

    public EclipseJdtFormatterStepImpl(Properties settings) throws Exception {
        SpotlessEclipseFramework.setup(plugins -> {
            plugins.applyDefault();
            plugins.add((BundleActivator)new JavaCore());
        });
        this.codeFormatter = ToolFactory.createCodeFormatter((Map)settings, (int)ToolFactory.M_FORMAT_EXISTING);
    }

    public String format(String raw) throws Exception {
        TextEdit edit = this.codeFormatter.format(4104, raw, 0, raw.length(), 0, "\n");
        if (edit == null) {
            throw new IllegalArgumentException("Invalid java syntax for formatting.");
        }
        Document doc = new Document(raw);
        edit.apply((IDocument)doc);
        return doc.get();
    }
}

