/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.base;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseCoreConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipsePluginConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseServiceConfig;
import com.diffplug.spotless.extra.eclipse.base.osgi.BundleConfig;
import com.diffplug.spotless.extra.eclipse.base.osgi.BundleController;
import com.diffplug.spotless.extra.eclipse.base.runtime.PluginRegistrar;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.preferences.Activator;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public final class SpotlessEclipseFramework {
    public static final String LINE_DELIMITER = "\n";
    private static SpotlessEclipseFramework INSTANCE = null;
    private final Function<Bundle, BundleException> registry;
    private final BundleController controller = new BundleController();

    private static <T> T createInstance(Class<? extends T> clazz) {
        try {
            Constructor<T> ctor = clazz.getConstructor(new Class[0]);
            return ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create instance for: " + clazz.getCanonicalName(), e);
        }
    }

    public static synchronized boolean setup() throws BundleException {
        return SpotlessEclipseFramework.setup((SpotlessEclipsePluginConfig plugins) -> plugins.applyDefault());
    }

    public static synchronized boolean setup(Consumer<SpotlessEclipsePluginConfig> plugins) throws BundleException {
        return SpotlessEclipseFramework.setup(config -> config.applyDefault(), plugins);
    }

    public static synchronized boolean setup(Consumer<SpotlessEclipseServiceConfig> config, Consumer<SpotlessEclipsePluginConfig> plugins) throws BundleException {
        return SpotlessEclipseFramework.setup(core -> core.applyDefault(), config, plugins);
    }

    public static synchronized boolean setup(final Consumer<SpotlessEclipseCoreConfig> core, final Consumer<SpotlessEclipseServiceConfig> services, final Consumer<SpotlessEclipsePluginConfig> plugins) throws BundleException {
        if (null != INSTANCE) {
            return false;
        }
        SpotlessEclipseFramework.setup(new SpotlessEclipseConfig(){

            @Override
            public void registerBundles(SpotlessEclipseCoreConfig config) {
                core.accept(config);
            }

            @Override
            public void registerServices(SpotlessEclipseServiceConfig config) {
                services.accept(config);
            }

            @Override
            public void activatePlugins(SpotlessEclipsePluginConfig config) {
                plugins.accept(config);
            }
        });
        return true;
    }

    public static synchronized void setup(SpotlessEclipseConfig config) throws BundleException {
        if (null == INSTANCE) {
            INSTANCE = new SpotlessEclipseFramework();
            config.registerServices(INSTANCE.getServiceConfig());
            SpotlessEclipseCoreConfig coreConfig = new SpotlessEclipseCoreConfig();
            config.registerBundles(coreConfig);
            INSTANCE.startCoreBundles(coreConfig);
            SpotlessEclipsePluginConfig pluginConfig = new SpotlessEclipsePluginConfig();
            config.activatePlugins(pluginConfig);
            for (Class<?> extension : pluginConfig.getExtensions()) {
                INSTANCE.addExtension(extension);
            }
            for (BundleConfig.Entry plugin : pluginConfig.get()) {
                INSTANCE.addPlugin(plugin.state, plugin.activator);
            }
            config.customize();
        }
    }

    private SpotlessEclipseFramework() throws BundleException {
        this.registry = pluginBundle -> PluginRegistrar.register(pluginBundle);
    }

    private SpotlessEclipseServiceConfig getServiceConfig() {
        return this.controller.getServices();
    }

    private void addExtension(Class<?> clazzInBundleJar) throws BundleException {
        this.controller.addBundle(clazzInBundleJar, this.registry);
    }

    private void addPlugin(int state, BundleActivator plugin) throws BundleException {
        this.controller.addBundle(state, plugin, this.registry);
    }

    private void startCoreBundles(SpotlessEclipseCoreConfig coreConfig) throws BundleException {
        this.addMandatoryServiceIfMissing(SAXParserFactory.class, SAXParserFactory.newInstance());
        InternalPlatform.getDefault().start((BundleContext)this.controller);
        for (BundleConfig.Entry coreBundle : coreConfig.get()) {
            try {
                BundleContext context = this.controller.createContext(coreBundle.state);
                coreBundle.activator.start(context);
            }
            catch (Exception e) {
                throw new BundleException(String.format("Failed to start %s", coreBundle.activator.getClass().getName()), 5, (Throwable)e);
            }
        }
    }

    private <S> void addMandatoryServiceIfMissing(Class<S> interfaceClass, S service) {
        if (null == this.controller.getServiceReference(interfaceClass)) {
            this.controller.getServices().add(interfaceClass, service);
        }
    }

    public static enum DefaultPlugins {
        RESOURCES(ResourcesPlugin.class);

        private final Class<? extends BundleActivator> pluginClass;

        private DefaultPlugins(Class<? extends BundleActivator> clazz) {
            this.pluginClass = clazz;
        }

        public BundleActivator create() {
            return (BundleActivator)SpotlessEclipseFramework.createInstance(this.pluginClass);
        }

        public static List<BundleActivator> createAll() {
            return Arrays.stream(DefaultPlugins.values()).map(value -> value.create()).collect(Collectors.toList());
        }
    }

    public static enum DefaultBundles {
        PLATFORM(PlatformActivator.class, 4),
        REGISTRY(org.eclipse.core.internal.registry.osgi.Activator.class),
        PREFERENCES(Activator.class),
        COMMON(org.eclipse.core.internal.runtime.Activator.class);

        private final Class<? extends BundleActivator> activatorClass;
        private final int state;

        private DefaultBundles(Class<? extends BundleActivator> clazz) {
            this(clazz, 32);
        }

        private DefaultBundles(Class<? extends BundleActivator> clazz, int state) {
            this.activatorClass = clazz;
            this.state = state;
        }

        public BundleActivator create() {
            return (BundleActivator)SpotlessEclipseFramework.createInstance(this.activatorClass);
        }

        public int getDesiredState() {
            return this.state;
        }

        public static List<BundleConfig.Entry> createAll() {
            return Arrays.stream(DefaultBundles.values()).map(value -> new BundleConfig.Entry(value.create(), value.getDesiredState())).collect(Collectors.toList());
        }
    }
}

