/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.base.osgi;

import com.diffplug.spotless.extra.eclipse.base.osgi.BundleSet;
import com.diffplug.spotless.extra.eclipse.base.osgi.EclipseBundleLookup;
import com.diffplug.spotless.extra.eclipse.base.osgi.ServiceCollection;
import com.diffplug.spotless.extra.eclipse.base.osgi.SimpleBundle;
import com.diffplug.spotless.extra.eclipse.base.osgi.StaticBundleContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.packageadmin.PackageAdmin;

public final class BundleController
implements StaticBundleContext {
    private static final String ECLIPSE_LAUNCHER_SYMBOLIC_NAME = "org.eclipse.osgi";
    private final SimpleBundle systemBundle;
    private final Map<String, String> properties;
    private final ServiceCollection services;
    private final BundleSet bundles;

    public BundleController() throws BundleException {
        System.setProperty("osgi.locking", "none");
        this.properties = new HashMap<String, String>();
        this.properties.put("eclipse.activateRuntimePlugins", Boolean.toString(false));
        this.properties.put("osgi.nl", "");
        this.bundles = new BundleSet();
        this.systemBundle = new SimpleBundle(this, 32);
        this.bundles.add(this.systemBundle);
        this.services = new ServiceCollection(this.systemBundle, this.properties);
        EclipseBundleLookup bundleLookup = new EclipseBundleLookup(this.systemBundle, this.bundles);
        this.services.add(PackageAdmin.class, bundleLookup);
        this.services.add(FrameworkWiring.class, bundleLookup);
        this.bundles.add(new SimpleBundle(this.systemBundle, ECLIPSE_LAUNCHER_SYMBOLIC_NAME, 32));
    }

    public ServiceCollection getServices() {
        return this.services;
    }

    public void addBundle(int bundleState, BundleActivator activator, Function<Bundle, BundleException> register) throws BundleException {
        BundleControllerContextFacade contextFacade = new BundleControllerContextFacade(this, bundleState, activator);
        this.bundles.add(contextFacade.getBundle());
        BundleException exception = register.apply(contextFacade.getBundle());
        if (null != exception) {
            throw exception;
        }
        try {
            activator.start((BundleContext)contextFacade);
        }
        catch (Exception e) {
            throw new BundleException(String.format("Failed do start %s.", activator.getClass().getName()), 5, (Throwable)e);
        }
    }

    public BundleContext createContext(int state) {
        if (state == this.systemBundle.getState()) {
            return this;
        }
        return new BundleControllerContextFacade(this.systemBundle, state);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public Bundle getBundle() {
        return this.systemBundle;
    }

    public Bundle[] getBundles() {
        Collection<Bundle> shallowCopy = this.bundles.getAll();
        return shallowCopy.toArray(new Bundle[shallowCopy.size()]);
    }

    public Bundle getBundle(long id) {
        return this.bundles.get(id);
    }

    public Bundle getBundle(String location) {
        if ("System Bundle".equals(location)) {
            return this.systemBundle;
        }
        return null;
    }

    @Override
    public ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        String interfaceClassName = null == clazz ? filter : clazz;
        return this.services.getReferences(interfaceClassName);
    }

    public <S> S getService(ServiceReference<S> reference) {
        return this.services.getService(reference);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return this.services.createFilter(filter);
    }

    private static class BundleControllerContextFacade
    implements StaticBundleContext {
        private final BundleContext context;
        private final Bundle bundle;

        private BundleControllerContextFacade(BundleContext context, int bundleState, BundleActivator activator) throws BundleException {
            this.context = context;
            this.bundle = new SimpleBundle((BundleContext)this, bundleState, activator);
        }

        private BundleControllerContextFacade(SimpleBundle bundle, int bundleState) {
            this.context = bundle.getBundleContext();
            this.bundle = new SimpleBundle(bundle, bundleState);
        }

        public String getProperty(String key) {
            return this.context.getProperty(key);
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public Bundle[] getBundles() {
            return this.context.getBundles();
        }

        public Bundle getBundle(long id) {
            return this.context.getBundle(id);
        }

        public Bundle getBundle(String location) {
            return this.context.getBundle(location);
        }

        @Override
        public ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
            return this.context.getAllServiceReferences(clazz, filter);
        }

        public <S> S getService(ServiceReference<S> reference) {
            return (S)this.context.getService(reference);
        }

        public Filter createFilter(String filter) throws InvalidSyntaxException {
            return this.context.createFilter(filter);
        }
    }
}

