/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.base.osgi;

import com.diffplug.spotless.extra.eclipse.base.osgi.ResourceAccessor;
import com.diffplug.spotless.extra.eclipse.base.osgi.StaticBundle;
import com.diffplug.spotless.extra.eclipse.base.osgi.TemporaryBundle;
import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class SimpleBundle
implements StaticBundle,
TemporaryBundle {
    private final String name;
    private final int state;
    private final BundleContext context;
    private final int id;
    private final ResourceAccessor resources;

    SimpleBundle(BundleContext context, int state) throws BundleException {
        this(context, state, new ResourceAccessor());
    }

    SimpleBundle(BundleContext context, int state, BundleActivator activator) throws BundleException {
        this(context, state, new ResourceAccessor(activator.getClass()));
    }

    private SimpleBundle(BundleContext context, int state, ResourceAccessor resources) throws BundleException {
        this.state = state;
        this.context = context;
        this.resources = resources;
        this.id = context.getBundles().length;
        this.name = resources.getManifestName();
    }

    SimpleBundle(SimpleBundle master, String name, int state) {
        this.name = name;
        this.state = state;
        this.context = master.context;
        this.resources = master.resources;
        this.id = this.context.getBundles().length;
    }

    SimpleBundle(SimpleBundle master, int state) {
        this.state = state;
        this.context = master.context;
        this.resources = master.resources;
        this.id = master.id;
        this.name = master.name;
    }

    public int getState() {
        return this.state;
    }

    public long getBundleId() {
        return this.id;
    }

    public ServiceReference<?>[] getRegisteredServices() {
        try {
            return this.context.getAllServiceReferences(null, null);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSymbolicName() {
        return this.name;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public Enumeration<String> getEntryPaths(String path) {
        return this.resources.getEntries(path);
    }

    public URL getEntry(String path) {
        return this.resources.getEntry(path);
    }
}

