/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse;

import com.diffplug.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.util.Node;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;

public class ResourceFilter {
    private EnumSet<Kind> kinds = EnumSet.noneOf(Kind.class);
    private boolean caseSensitive = false;
    private boolean isRegex = false;
    private Matcher matcher;
    private String matchValue;

    public static ResourceFilter include() {
        return new ResourceFilter(Kind.INCLUDE_ONLY);
    }

    public static ResourceFilter exclude() {
        return new ResourceFilter(Kind.EXCLUDE_ALL);
    }

    private ResourceFilter(Kind initial) {
        this.kinds.add(initial);
    }

    public ResourceFilter files() {
        return this.addKind(Kind.FILES);
    }

    public ResourceFilter folders() {
        return this.addKind(Kind.FOLDERS);
    }

    public ResourceFilter filesAndFolders() {
        return this.addKind(Kind.FILES, Kind.FOLDERS);
    }

    ResourceFilter addKind(Kind ... toAdd) {
        for (Kind kind : toAdd) {
            this.kinds.add(kind);
        }
        return this;
    }

    public ResourceFilter name(String value) {
        return this.setMatcher(value, Matcher.name);
    }

    public ResourceFilter location(String value) {
        return this.setMatcher(value, Matcher.location);
    }

    public ResourceFilter projectRelativePath(String value) {
        return this.setMatcher(value, Matcher.projectRelativePath);
    }

    private ResourceFilter setMatcher(String matchValue, Matcher matcher) {
        Preconditions.checkArgument((this.matcher == null ? 1 : 0) != 0, (String)"Can only call one of %s", (Object[])new Object[]{Arrays.asList(Matcher.values())});
        this.matchValue = Objects.requireNonNull(matchValue);
        this.matcher = Objects.requireNonNull(matcher);
        return this;
    }

    public ResourceFilter caseSensitive() {
        this.caseSensitive = true;
        return this;
    }

    public ResourceFilter regex() {
        this.isRegex = true;
        return this;
    }

    public ResourceFilter recursive() {
        return this.addKind(Kind.INHERITABLE);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kinds, this.caseSensitive, this.isRegex, this.matcher, this.matchValue});
    }

    void checkValid() {
        Preconditions.checkState((this.matcher != null ? 1 : 0) != 0, (String)"Must call one of %s", (Object[])new Object[]{Arrays.asList(Matcher.values())});
        Preconditions.checkState((this.matchValue != null ? 1 : 0) != 0, (String)"Must call one of %s", (Object[])new Object[]{Arrays.asList(Matcher.values())});
        Preconditions.checkState((this.kinds.contains((Object)Kind.FILES) || this.kinds.contains((Object)Kind.FOLDERS) ? 1 : 0) != 0, (Object)"Must call one of files(), folders(), or filesAndFolders()");
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_INFERRED"})
    void appendToFilteredResources(Node filteredResources) {
        Preconditions.checkArgument((boolean)filteredResources.name().equals("filteredResources"));
        this.checkValid();
        Node filterNode = filteredResources.appendNode((Object)"filter");
        filterNode.appendNode((Object)"id", (Object)this.hashCode());
        filterNode.appendNode((Object)"name", (Object)"");
        filterNode.appendNode((Object)"type", (Object)Kind.create(this.kinds));
        Node matcherNode = filterNode.appendNode((Object)"matcher");
        matcherNode.appendNode((Object)"id", (Object)"org.eclipse.ui.ide.multiFilter");
        matcherNode.appendNode((Object)"arguments", (Object)("1.0-" + this.matcher.name() + "-matches-" + this.caseSensitive + "-" + this.isRegex + "-" + this.matchValue));
    }

    static enum Kind {
        INCLUDE_ONLY,
        EXCLUDE_ALL,
        FILES,
        FOLDERS,
        INHERITABLE;


        int flag() {
            return 1 << this.ordinal();
        }

        public static int create(EnumSet<Kind> kinds) {
            return Kind.type(kinds.toArray(new Kind[kinds.size()]));
        }

        public static int type(Kind ... kinds) {
            int value = 0;
            for (Kind kind : kinds) {
                value |= kind.flag();
            }
            return value;
        }
    }

    static enum Matcher {
        name,
        projectRelativePath,
        location;

    }
}

