/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse.apt;

import groovy.lang.Closure;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.plugins.ide.api.PropertiesFileContentMerger;
import org.gradle.util.ConfigureUtil;

public class EclipseJdtApt {
    private final ProviderFactory providers;
    private final ProjectLayout layout;
    private final PropertiesFileContentMerger file;
    private final Property<Boolean> aptEnabled;
    private final Property<Boolean> reconcileEnabled;
    private final Property<File> genSrcDir;
    private final Property<File> genTestSrcDir;
    @Nullable
    private Supplier<Map<String, ?>> processorOptionsSupplier;
    @Nullable
    private Map<String, ?> processorOptions;

    @Deprecated
    public EclipseJdtApt(Project project, PropertiesFileContentMerger file) {
        this(project, project.getProviders(), project.getLayout(), file);
    }

    @Inject
    public EclipseJdtApt(Project project, ProviderFactory providers, ProjectLayout layout, PropertiesFileContentMerger file) {
        this.providers = providers;
        this.layout = layout;
        this.file = file;
        this.aptEnabled = project.getObjects().property(Boolean.class);
        this.aptEnabled.set((Object)true);
        this.reconcileEnabled = project.getObjects().property(Boolean.class);
        this.reconcileEnabled.set((Object)true);
        this.genSrcDir = project.getObjects().property(File.class);
        this.genSrcDir.set((Object)project.file((Object)".apt_generated"));
        this.genTestSrcDir = project.getObjects().property(File.class);
        this.genTestSrcDir.set((Object)project.file((Object)".apt_generated_tests"));
        this.processorOptionsSupplier = LinkedHashMap::new;
    }

    public boolean isAptEnabled() {
        return (Boolean)this.aptEnabled.get();
    }

    public void setAptEnabled(boolean aptEnabled) {
        this.aptEnabled.set((Object)aptEnabled);
    }

    public void setAptEnabled(Provider<Boolean> aptEnabled) {
        this.aptEnabled.set(aptEnabled);
    }

    public boolean isReconcileEnabled() {
        return (Boolean)this.reconcileEnabled.get();
    }

    public void setReconcileEnabled(boolean reconcileEnabled) {
        this.reconcileEnabled.set((Object)reconcileEnabled);
    }

    public void setReconcileEnabled(Provider<Boolean> reconcileEnabled) {
        this.reconcileEnabled.set(reconcileEnabled);
    }

    public File getGenSrcDir() {
        return ((RegularFile)this.layout.getProjectDirectory().file(this.genSrcDir.map(File::getAbsolutePath)).get()).getAsFile();
    }

    public void setGenSrcDir(File genSrcDir) {
        this.genSrcDir.set((Object)Objects.requireNonNull(genSrcDir));
    }

    public void setGenSrcDir(Object genSrcDir) {
        Objects.requireNonNull(genSrcDir);
        this.genSrcDir.set(this.providers.provider(() -> this.layout.getProjectDirectory().files(new Object[]{genSrcDir}).getSingleFile()));
    }

    public File getGenTestSrcDir() {
        return ((RegularFile)this.layout.getProjectDirectory().file(this.genTestSrcDir.map(File::getAbsolutePath)).get()).getAsFile();
    }

    public void setGenTestSrcDir(File genTestSrcDir) {
        this.genTestSrcDir.set((Object)Objects.requireNonNull(genTestSrcDir));
    }

    public void setGenTestSrcDir(Object genTestSrcDir) {
        Objects.requireNonNull(genTestSrcDir);
        this.genSrcDir.set(this.providers.provider(() -> this.layout.getProjectDirectory().files(new Object[]{genTestSrcDir}).getSingleFile()));
    }

    @Nullable
    public Map<String, ?> getProcessorOptions() {
        if (this.processorOptions == null && this.processorOptionsSupplier != null) {
            this.processorOptions = this.processorOptionsSupplier.get();
            this.processorOptionsSupplier = null;
            if (this.processorOptions != null) {
                this.processorOptions = new LinkedHashMap(this.processorOptions);
            }
        }
        return this.processorOptions;
    }

    public void setProcessorOptions(@Nullable Map<String, ?> processorOptions) {
        this.setProcessorOptions(() -> processorOptions);
    }

    void setProcessorOptions(Supplier<Map<String, ?>> processorOptions) {
        this.processorOptionsSupplier = processorOptions;
        this.processorOptions = null;
    }

    public PropertiesFileContentMerger getFile() {
        return this.file;
    }

    public void file(Closure<? super PropertiesFileContentMerger> closure) {
        ConfigureUtil.configure(closure, (Object)this.file);
    }

    public void file(Action<? super PropertiesFileContentMerger> action) {
        action.execute((Object)this.file);
    }
}

