/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import aQute.lib.filter.Filter;
import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.Throwing;
import com.diffplug.common.collect.HashBasedTable;
import com.diffplug.common.collect.HashMultimap;
import com.diffplug.common.collect.SetMultimap;
import com.diffplug.common.collect.Sets;
import com.diffplug.common.collect.Table;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.ZipMisc;
import com.diffplug.gradle.pde.ExplicitVersionPolicy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.osgi.framework.Version;

class PluginCatalog {
    private final SetMultimap<String, Version> availableVersions = HashMultimap.create();
    private final Table<String, Version, File> toFile = HashBasedTable.create();
    private final ExplicitVersionPolicy versionPolicy;
    private final Set<String> unsupportedPlatform = Sets.newHashSet();
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String BUNDLE_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String ECLIPSE_PLATFORM_FILTER = "Eclipse-PlatformFilter";

    public PluginCatalog(ExplicitVersionPolicy versionPolicy, List<SwtPlatform> supported, List<File> roots) {
        this.versionPolicy = Objects.requireNonNull(versionPolicy);
        for (File root : roots) {
            List<File> files;
            Preconditions.checkArgument((boolean)root.exists(), (String)"Root '%s' does not exist.", (Object[])new Object[]{root});
            File pluginRoot = root;
            File plugins = new File(root, "plugins");
            if (plugins.exists()) {
                pluginRoot = plugins;
            }
            Preconditions.checkArgument(((files = FileMisc.list(pluginRoot)).size() > 0 ? 1 : 0) != 0, (Object)("No plugins found in " + root));
            files.stream().filter(file -> file.isFile() && file.getName().endsWith(".jar")).forEach(Errors.rethrow().wrap(file -> ZipMisc.read(file, MANIFEST_PATH, (Throwing.Specific.Consumer<InputStream, IOException>)((Throwing.Specific.Consumer)input -> this.addManifest(supported, new Manifest((InputStream)input), (File)file)))));
            files.stream().filter(file -> file.isDirectory()).forEach(Errors.rethrow().wrap(folder -> {
                File manifestFile = new File((File)folder, MANIFEST_PATH);
                if (manifestFile.exists()) {
                    try (FileInputStream input = new FileInputStream(new File((File)folder, MANIFEST_PATH));){
                        this.addManifest(supported, new Manifest(input), (File)folder);
                    }
                }
            }));
        }
    }

    private void addManifest(List<SwtPlatform> supported, Manifest parsed, File plugin) {
        String platformFilter;
        String name = parsed.getMainAttributes().getValue(BUNDLE_NAME);
        int splitIdx = name.indexOf(59);
        if (splitIdx > 0) {
            name = name.substring(0, splitIdx);
        }
        if ((platformFilter = parsed.getMainAttributes().getValue(ECLIPSE_PLATFORM_FILTER)) != null) {
            Filter filter = new Filter(platformFilter.replace(" ", ""));
            boolean isSupportedOS = supported.stream().anyMatch(Errors.rethrow().wrapPredicate(platform -> filter.matchMap(platform.platformProperties())));
            if (!isSupportedOS) {
                this.unsupportedPlatform.add(name);
                return;
            }
        }
        String versionRaw = parsed.getMainAttributes().getValue(BUNDLE_VERSION);
        Version version = Version.parseVersion((String)versionRaw);
        this.availableVersions.put((Object)name, (Object)version);
        this.toFile.put((Object)name, (Object)version, (Object)plugin);
    }

    boolean isSupportedPlatform(String plugin) {
        return !this.unsupportedPlatform.contains(plugin);
    }

    @Nullable
    Set<Version> getVersionsFor(String plugin) {
        return this.versionPolicy.useVersions(plugin, this.availableVersions.get((Object)plugin));
    }

    File getFile(String plugin, Version version) {
        return (File)this.toFile.get((Object)plugin, (Object)version);
    }

    public String toString() {
        return this.availableVersions.entries().stream().map(entry -> entry.toString()).collect(Collectors.joining("\n"));
    }
}

