/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import com.diffplug.common.base.Comparison;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.StringPrinter;
import com.diffplug.common.swt.os.OS;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.GoomphCacheLocations;
import com.diffplug.gradle.ZipMisc;
import com.diffplug.gradle.eclipserunner.EclipseApp;
import com.diffplug.gradle.eclipserunner.EclipseRunner;
import com.diffplug.gradle.eclipserunner.NativeRunner;
import com.diffplug.gradle.p2.P2Model;
import com.diffplug.gradle.pde.EclipseRelease;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.osgi.framework.Version;

public class PdeInstallation
implements EclipseRunner {
    static final String DOWNLOAD_FILE = "/goomph-pde-bootstrap.zip";
    static final String VERSIONED_DOWNLOAD_FILE = "/goomph-pde-bootstrap-%s.zip";
    final EclipseRelease release;
    private File pdeBuildFolder;
    static final String TOKEN = "installed";

    public static PdeInstallation fromProject(Project project) {
        String version = (String)project.getProperties().get("GOOMPH_PDE_VER");
        String deprecatedUpdateSite = (String)project.getProperties().get("GOOMPH_PDE_UDPATE_SITE");
        if (deprecatedUpdateSite != null) {
            project.getLogger().warn("Property GOOMPH_PDE_UDPATE_SITE is deprecated, please use GOOMPH_PDE_UPDATE_SITE instead.");
        }
        String updateSite = Optional.ofNullable((String)project.getProperties().get("GOOMPH_PDE_UPDATE_SITE")).orElse(deprecatedUpdateSite);
        String id = (String)project.getProperties().get("GOOMPH_PDE_ID");
        String USAGE = StringPrinter.buildStringFromLines((String[])new String[]{"You must specify which version of Eclipse should be used by Goomph.", "Option #1: To use an officially supported release, use this:", "GOOMPH_PDE_VER=4.5.2 (or any of " + EclipseRelease.supportedRange() + ")", "Option #2: To use any release (e.g. milestone, nightly, etc)", "GOOMPH_PDE_VER=<any version>", "GOOMPH_PDE_UPDATE_SITE=<url to update site>", "GOOMPH_PDE_ID=<the ID used for caching, cannot be a version listed in Option #1)", "", "You must do one or the other, specify only VER for Option #1,", "or specify VER, UPDATE_SITE, and ID for Option #2"});
        if (version == null) {
            throw new IllegalArgumentException(USAGE);
        }
        if (updateSite == null && id == null) {
            try {
                return new PdeInstallation(EclipseRelease.official(version));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(USAGE, e);
            }
        }
        if (updateSite == null || id == null) {
            throw new IllegalArgumentException(USAGE);
        }
        return PdeInstallation.from(EclipseRelease.createWithIdVersionUpdatesite(id, version, updateSite));
    }

    public static PdeInstallation from(EclipseRelease release) {
        return new PdeInstallation(release);
    }

    public PdeInstallation(EclipseRelease release) {
        this.release = Objects.requireNonNull(release);
        if (OS.getNative().isMac() && Comparison.compare((Comparable)release.version(), (Comparable)Version.parseVersion((String)"4.5.0")) == Comparison.LESSER) {
            throw new IllegalArgumentException("On mac, must be 4.5.0 (Mars) or later, because of folder layout problems.");
        }
    }

    private File getRootFolder() {
        return new File(GoomphCacheLocations.pdeBootstrap(), this.release.toString() + FileMisc.macApp());
    }

    File getPdeBuildFolder() throws Exception {
        this.ensureInstalled();
        return Objects.requireNonNull(this.pdeBuildFolder);
    }

    File getPdeBuildProductBuildXml() throws Exception {
        return this.getPdeBuildFolder().toPath().resolve("scripts/productBuild/productBuild.xml").toFile();
    }

    public EclipseApp productBuildCmd(File buildDir) throws Exception {
        EclipseApp antApp = new EclipseApp("org.eclipse.ant.core.antRunner");
        antApp.addArg("buildfile", this.getPdeBuildProductBuildXml().getAbsolutePath());
        antApp.addArg("Dbuilder=" + FileMisc.quote(buildDir));
        return antApp;
    }

    private void ensureInstalled() throws Exception {
        if (!this.isInstalled()) {
            this.install();
        }
    }

    private boolean isInstalled() throws IOException {
        Optional<String> pdeBuild = FileMisc.readToken(this.getRootFolder(), TOKEN);
        this.pdeBuildFolder = pdeBuild.map(File::new).orElse(null);
        return this.pdeBuildFolder != null;
    }

    private void install() throws Exception {
        if (GoomphCacheLocations.pdeBootstrapUrl().isPresent()) {
            String url = GoomphCacheLocations.pdeBootstrapUrl().get();
            System.out.print("Installing pde " + this.release + " from " + url + "... ");
            File target = new File(this.getRootFolder(), DOWNLOAD_FILE);
            try {
                FileMisc.download(url + this.release.version() + DOWNLOAD_FILE, target);
            }
            catch (FileNotFoundException ex) {
                FileMisc.download(url + this.release.version() + String.format(VERSIONED_DOWNLOAD_FILE, this.release.version()), target);
            }
            ZipMisc.unzip(target, target.getParentFile());
            FileMisc.forceDelete(target);
        } else {
            System.out.print("Installing pde " + this.release + "... ");
            this.obtainBootstrap(this.release);
        }
        File bundleInfo = new File(this.getContentsEclipse(), "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
        Preconditions.checkArgument((boolean)bundleInfo.isFile(), (String)"Needed to find the pde.build folder: %s", (Object[])new Object[]{bundleInfo});
        String pdeBuildLine = Files.readAllLines(bundleInfo.toPath()).stream().filter(line -> line.startsWith("org.eclipse.pde.build,")).findFirst().get();
        String pdeBuildVersion = pdeBuildLine.split(",")[1];
        this.pdeBuildFolder = new File(GoomphCacheLocations.bundlePool(), "plugins/org.eclipse.pde.build_" + pdeBuildVersion);
        FileMisc.writeToken(this.getRootFolder(), TOKEN, this.pdeBuildFolder.getAbsolutePath());
        System.out.println("Success.");
    }

    private void obtainBootstrap(EclipseRelease release) throws Exception {
        P2Model.DirectorApp directorApp = this.p2model().directorApp(this.getRootFolder(), "goomph-pde-bootstrap-" + release);
        directorApp.bundlepool(GoomphCacheLocations.bundlePool());
        directorApp.platform(SwtPlatform.getRunning());
        directorApp.runUsingBootstrapper();
    }

    private File getContentsEclipse() {
        if (OS.getNative().isMac()) {
            return new File(this.getRootFolder(), "Contents/Eclipse");
        }
        return this.getRootFolder();
    }

    P2Model p2model() {
        P2Model model = new P2Model();
        model.addRepo(this.release.updateSite());
        model.addIU("org.eclipse.platform.ide");
        model.addFeature("org.eclipse.jdt");
        model.addFeature("org.eclipse.pde");
        return model;
    }

    private String getEclipseConsoleExecutable() {
        return (String)OS.getNative().winMacLinux((Object)"eclipsec.exe", (Object)"Contents/MacOS/eclipse", (Object)"eclipse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(List<String> args) throws Exception {
        this.ensureInstalled();
        ArrayList<String> actualArgs = new ArrayList<String>();
        actualArgs.add("-data");
        File workspace = new File(this.getRootFolder(), FileMisc.macContentsEclipse() + "workspace");
        actualArgs.add(workspace.getAbsolutePath());
        actualArgs.addAll(args);
        try {
            new NativeRunner(new File(this.getRootFolder(), this.getEclipseConsoleExecutable())).run(actualArgs);
        }
        finally {
            FileUtils.deleteDirectory((File)workspace);
        }
    }
}

