/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.oomph;

import com.diffplug.gradle.osgi.OsgiExecable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class EclipseMisc {
    public static final String ID_PROJECT_IMPORT = "import projects";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void withService(Class<T> clazz, ThrowingConsumer<T> action) {
        BundleContext bundleContext = FrameworkUtil.getBundle(OsgiExecable.class).getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(clazz);
        Object service = bundleContext.getService(reference);
        try {
            action.accept(service);
        }
        catch (Throwable t) {
            EclipseMisc.logException(t);
        }
        finally {
            bundleContext.ungetService(reference);
        }
    }

    public static void logException(Throwable t) {
        t.printStackTrace();
        Status status = new Status(4, "goomph", t.getMessage(), t);
        StatusManager.getManager().handle((IStatus)status);
    }

    public static void waitForJobsToFinish() {
        EclipseMisc.withService(IJobManager.class, jobManager -> {
            Job job;
            while ((job = jobManager.currentJob()) != null) {
                System.out.print("    waiting for " + job.getName() + " to finish... ");
                job.join();
                System.out.println("complete.");
            }
        });
    }

    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Throwable;
    }
}

