/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.osgi;

import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.JRE;
import com.diffplug.gradle.SerializableMisc;
import com.diffplug.gradle.ZipMisc;
import com.diffplug.gradle.osgi.OsgiExecable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class OsgiExecImp {
    private static final String BUNDLE_SYMBOLIC_NAME = "com.diffplug.gradle.goomph";

    OsgiExecImp() {
    }

    static Bundle loadBundle(BundleContext context) throws Exception {
        for (Bundle bundle : context.getBundles()) {
            if (!BUNDLE_SYMBOLIC_NAME.equals(bundle.getSymbolicName())) continue;
            return bundle;
        }
        for (URL uRL : JRE.getClasspath(OsgiExecImp.class.getClassLoader())) {
            String name = uRL.getFile();
            if (name == null) continue;
            if (name.contains("/goomph")) {
                return context.installBundle(FileMisc.asUrl(new File(name)));
            }
            if (!name.contains("/long-classpath")) continue;
            String content = ZipMisc.read(new File(name), "META-INF/MANIFEST.MF");
            try (ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
                Manifest manifest = new Manifest(input);
                String classpath = manifest.getMainAttributes().getValue("Class-Path");
                for (String piece : classpath.split(" ")) {
                    if (!piece.contains("/goomph")) continue;
                    Bundle bundle = context.installBundle(piece);
                    return bundle;
                }
            }
        }
        throw new IllegalArgumentException("Unable to find goomph jar");
    }

    public static <T extends OsgiExecable> void execInternal(File tempFile) throws Throwable {
        OsgiExecable object = (OsgiExecable)SerializableMisc.read(tempFile);
        object.run();
        SerializableMisc.write(tempFile, object);
    }
}

