/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.p2;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedJar {
    private String symbolicName;
    private String version;
    private boolean isSource;
    private static Logger logger = LoggerFactory.getLogger(ParsedJar.class);

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSource() {
        return this.isSource;
    }

    public static ParsedJar parse(File file) {
        try {
            return new ParsedJar(file);
        }
        catch (Exception e) {
            logger.info("Unabled to parse jar " + file, (Throwable)e);
            return new ParsedJar(file.getName());
        }
    }

    private ParsedJar(String name) {
        this.symbolicName = name;
        this.version = "0.0.0";
        this.isSource = false;
    }

    private ParsedJar(File osgiJar) throws IOException {
        try (JarFile jarFile = new JarFile(osgiJar);){
            if (jarFile.getManifest() != null) {
                Attributes attr = jarFile.getManifest().getMainAttributes();
                this.symbolicName = ParsedJar.beforeSemicolon(attr.getValue("Bundle-SymbolicName"));
                this.version = attr.getValue("Bundle-Version");
                String source = attr.getValue("Eclipse-SourceBundle");
                if (source != null) {
                    this.isSource = true;
                    this.symbolicName = ParsedJar.beforeSemicolon(source);
                } else {
                    this.isSource = false;
                }
            } else {
                String name = osgiJar.getName();
                int lastUnderscore = name.lastIndexOf("_");
                this.symbolicName = name.substring(0, lastUnderscore);
                this.version = name.substring(lastUnderscore + 1);
                this.isSource = false;
                logger.warn(osgiJar.getAbsolutePath() + " has no manifest.  Guessing name=" + this.symbolicName + " and version=" + this.version);
            }
        }
    }

    private static String beforeSemicolon(String input) {
        int firstSemiColon = input.indexOf(59);
        if (firstSemiColon == -1) {
            return input.trim();
        }
        return input.substring(0, firstSemiColon).trim();
    }

    public String toString() {
        return "name=" + this.symbolicName + " version=" + this.version + " isSource=" + this.isSource;
    }
}

