/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.swt;

import com.diffplug.common.collect.ImmutableList;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.LegacyPlugin;
import com.diffplug.gradle.ProjectPlugin;
import com.diffplug.gradle.p2.AsMavenGroup;
import com.diffplug.gradle.p2.AsMavenPlugin;
import com.diffplug.gradle.pde.EclipseRelease;
import java.util.List;
import java.util.Optional;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;

@Deprecated
public class NativeDepsPlugin
extends ProjectPlugin {
    static final String PROP_VERSION = "SWT_VERSION";
    static final String PROP_REPO = "SWT_P2_REPO";
    static final String PROP_GROUP = "SWT_P2_GROUP";
    static final String DEFAULT_GROUP = "eclipse-swt-deps";
    static final String SWT = "org.eclipse.swt";
    static final String JFACE = "org.eclipse.jface";
    static final String CORE_COMMANDS = "org.eclipse.core.commands";
    static final String EQUINOX_COMMON = "org.eclipse.equinox.common";
    static final List<String> DEPS = ImmutableList.of((Object)"org.eclipse.swt", (Object)"org.eclipse.jface", (Object)"org.eclipse.core.commands", (Object)"org.eclipse.equinox.common");

    static String getGroup(Project project) {
        String group = (String)project.getProperties().get(PROP_GROUP);
        return Optional.ofNullable(group).orElse(DEFAULT_GROUP);
    }

    static String getRepo(Project project) {
        String repo = (String)project.getProperties().get(PROP_REPO);
        String version = (String)project.getProperties().get(PROP_VERSION);
        if (repo != null) {
            return repo;
        }
        if (version != null) {
            return EclipseRelease.official(version).updateSite();
        }
        return EclipseRelease.latestOfficial().updateSite();
    }

    @Override
    protected void applyOnce(Project project) {
        LegacyPlugin.applyForCompat(project, Legacy.class);
        String swtGroup = NativeDepsPlugin.getGroup(project);
        AsMavenPlugin asMavenPlugin = (AsMavenPlugin)project.getPlugins().apply(AsMavenPlugin.class);
        asMavenPlugin.extension().group(swtGroup, (Action<AsMavenGroup>)((Action)group -> {
            group.repo(NativeDepsPlugin.getRepo(project));
            DEPS.forEach(group::iu);
        }));
        project.getPlugins().apply(JavaPlugin.class);
        for (String dep : DEPS) {
            project.getDependencies().add("compile", (Object)(swtGroup + ":" + dep + ":+"));
        }
        project.getDependencies().add("compile", (Object)(swtGroup + ":" + SWT + "." + SwtPlatform.getRunning() + ":+"));
    }

    public static class Legacy
    extends LegacyPlugin {
        public Legacy() {
            super(NativeDepsPlugin.class, "com.diffplug.swt.nativedeps");
        }
    }
}

