/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import com.diffplug.common.base.StringPrinter;
import com.diffplug.common.collect.ImmutableList;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.Lazyable;
import com.diffplug.gradle.pde.ExplicitVersionPolicy;
import com.diffplug.gradle.pde.PdeBuildProperties;
import com.diffplug.gradle.pde.PluginCatalog;
import com.diffplug.gradle.pde.ProductFileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;

public class PdeProductBuildConfig {
    private final Project project;
    String id;
    Object productPluginDir;
    String productFileWithinPlugin;
    String version;
    private String[] productFileLines;
    final Lazyable<ExplicitVersionPolicy> explicitVersionPolicy = ExplicitVersionPolicy.createLazyable();
    static final ImmutableList<String> POSSIBLE_ICON_SUFFIXES = ImmutableList.of((Object)".xpm", (Object)".icns", (Object)".ico");

    public PdeProductBuildConfig(Project project) {
        this.project = Objects.requireNonNull(project);
    }

    public void id(String id) {
        this.id = id;
    }

    public void productPluginDir(Object productPluginDir) {
        this.productPluginDir = productPluginDir;
    }

    public void productFileWithinPlugin(String productFileWithinPlugin) {
        this.productFileWithinPlugin = productFileWithinPlugin;
    }

    public void version(String version) {
        this.version = version;
    }

    public void explicitVersionPolicy(Action<ExplicitVersionPolicy> action) {
        this.explicitVersionPolicy.addLazyAction(action);
    }

    void setup(File destinationDir, PdeBuildProperties props, List<SwtPlatform> platforms, List<File> pluginPaths) throws IOException {
        Objects.requireNonNull(this.id, "Must set `id`");
        Objects.requireNonNull(this.productPluginDir, "Must set `productPluginDir`");
        Objects.requireNonNull(this.productFileWithinPlugin, "Must set `productFileWithinPlugin`");
        Objects.requireNonNull(this.version, "Must set `version`");
        if (pluginPaths.isEmpty()) {
            throw new IllegalArgumentException("There should be at least one pluginPath");
        }
        PluginCatalog catalog = new PluginCatalog(this.explicitVersionPolicy.getResult(), platforms, pluginPaths);
        File productPluginDir = this.project.file(this.productPluginDir);
        File tempProductDir = new File(destinationDir, productPluginDir.getName());
        this.copyImages(productPluginDir, tempProductDir);
        File productFile = productPluginDir.toPath().resolve(this.productFileWithinPlugin).toFile();
        this.productFileLines = ProductFileUtil.readLines(productFile);
        ProductFileUtil.extractProperties(this.productFileLines).forEach(props::setProp);
        File tempProductFile = tempProductDir.toPath().resolve(this.productFileWithinPlugin).toFile();
        this.transformProductFile(tempProductFile, catalog, this.version);
        props.setProp("topLevelElementType", "product");
        props.setProp("topLevelElementId", this.id);
        props.setProp("product", "/" + tempProductDir.getName() + "/" + this.productFileWithinPlugin);
    }

    void copyImages(File sourceDir, File destDir) throws IOException {
        FileFilter filter = file -> file.isDirectory() || POSSIBLE_ICON_SUFFIXES.stream().anyMatch(ending -> file.getName().endsWith((String)ending));
        boolean preserveFileDate = false;
        FileUtils.copyDirectory((File)sourceDir, (File)destDir, (FileFilter)filter, (boolean)preserveFileDate);
    }

    void transformProductFile(File output, PluginCatalog catalog, String version) throws IOException {
        String result = StringPrinter.buildString(printer -> {
            for (String line : this.productFileLines) {
                ProductFileUtil.transformProductFile(printer, line, catalog, version);
            }
        });
        Files.write(output.toPath(), result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

