/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.pde;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.swt.os.SwtPlatform;
import com.diffplug.gradle.FileMisc;
import com.diffplug.gradle.Lazyable;
import com.diffplug.gradle.pde.ExplicitVersionPolicy;
import com.diffplug.gradle.pde.PluginCatalog;
import com.diffplug.gradle.pde.ProductFileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.osgi.framework.Version;

public class CopyJarsUsingProductFile
extends DefaultTask {
    private Lazyable<ExplicitVersionPolicy> explicitVersionPolicy = ExplicitVersionPolicy.createLazyable();
    private List<File> inputFolders = new ArrayList<File>();
    private File productFile;
    private File destination;
    List<String> extras = new ArrayList<String>();

    public void from(Object from) {
        this.inputFolders.add(this.getProject().file(from));
        this.getInputs().dir(from);
    }

    public void productFile(Object file) {
        this.productFile = this.getProject().file(file);
        this.getInputs().file((Object)this.productFile);
    }

    public void explicitVersionPolicy(Action<ExplicitVersionPolicy> action) {
        this.explicitVersionPolicy.addLazyAction(action);
    }

    public void into(Object dest) {
        this.destination = this.getProject().file(dest);
        this.getOutputs().dir(dest);
    }

    public void extra(String extra) {
        this.extras.add(extra);
    }

    @TaskAction
    public void action() throws IOException {
        String[] lines;
        Objects.requireNonNull(this.explicitVersionPolicy, "Set explicitVersionPolicy");
        Objects.requireNonNull(this.destination, "Set destination");
        Preconditions.checkArgument((!this.inputFolders.isEmpty() ? 1 : 0) != 0, (Object)"Input folders should not be empty");
        FileMisc.cleanDir(this.destination);
        PluginCatalog catalog = new PluginCatalog(this.explicitVersionPolicy.getResult(), SwtPlatform.getAll(), this.inputFolders);
        String inputStr = new String(Files.readAllBytes(this.productFile.toPath()), StandardCharsets.UTF_8);
        for (String line : lines = FileMisc.toUnixNewline(inputStr).split("\n")) {
            ProductFileUtil.parsePlugin(line).ifPresent(plugin -> this.copyVersionsOfPlugin(catalog, (String)plugin));
        }
        this.extras.forEach(plugin -> this.copyVersionsOfPlugin(catalog, (String)plugin));
    }

    private void copyVersionsOfPlugin(PluginCatalog catalog, String plugin) {
        if (!catalog.isSupportedPlatform(plugin)) {
            return;
        }
        Set<Version> versions = catalog.getVersionsFor(plugin);
        for (Version version : versions) {
            File source = catalog.getFile(plugin, version);
            File dest = new File(this.destination, source.getName());
            Errors.rethrow().run(() -> {
                if (source.isFile()) {
                    FileUtils.copyFile((File)source, (File)dest);
                } else {
                    FileUtils.copyDirectory((File)source, (File)dest);
                }
            });
        }
    }
}

