/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.eclipse.apt;

import com.diffplug.gradle.eclipse.apt.AptPlugin;
import com.diffplug.gradle.eclipse.apt.EclipseFactorypath;
import com.diffplug.gradle.eclipse.apt.EclipseJdtApt;
import com.diffplug.gradle.eclipse.apt.GenerateEclipseFactorypath;
import com.diffplug.gradle.eclipse.apt.GenerateEclipseJdtApt;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.PropertiesTransformer;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.api.PropertiesFileContentMerger;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;

public class AptEclipsePlugin
implements Plugin<Project> {
    private static Action<Task> dependsOn(Object taskDependency) {
        return task -> task.dependsOn(new Object[]{taskDependency});
    }

    public void apply(Project project) {
        project.getPlugins().apply(AptPlugin.class);
        project.getPlugins().apply(EclipsePlugin.class);
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
            SourceSet testSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("test");
            this.configureEclipse(project, mainSourceSet, testSourceSet);
        });
    }

    private void configureEclipse(Project project, SourceSet mainSourceSet, SourceSet testSourceSet) {
        EclipseModel eclipseModel = (EclipseModel)project.getExtensions().getByType(EclipseModel.class);
        this.configureJdtApt(project, eclipseModel, mainSourceSet);
        this.configureFactorypath(project, eclipseModel, mainSourceSet, testSourceSet);
    }

    private void configureJdtApt(Project project, EclipseModel eclipseModel, SourceSet mainSourceSet) {
        EclipseJdtApt jdtApt = (EclipseJdtApt)((ExtensionAware)eclipseModel.getJdt()).getExtensions().create("apt", EclipseJdtApt.class, new Object[]{project, new PropertiesFileContentMerger(new PropertiesTransformer())});
        jdtApt.setAptEnabled((Provider<Boolean>)project.provider(() -> ((AptPlugin.AptOptions)project.getTasks().getByName(mainSourceSet.getCompileJavaTaskName()).getExtensions().getByType(AptPlugin.AptOptions.class)).isAnnotationProcessing()));
        jdtApt.setProcessorOptions(() -> ((AptPlugin.AptOptions)project.getTasks().getByName(mainSourceSet.getCompileJavaTaskName()).getExtensions().getByType(AptPlugin.AptOptions.class)).getProcessorArgs());
        eclipseModel.getJdt().getFile().withProperties(properties -> properties.setProperty("org.eclipse.jdt.core.compiler.processAnnotations", jdtApt.isAptEnabled() ? "enabled" : "disabled"));
        Object task = AptPlugin.IMPL.createTask(project, "eclipseJdtApt", GenerateEclipseJdtApt.class, generateEclipseJdtApt -> {
            generateEclipseJdtApt.setDescription("Generates the Eclipse JDT APT settings file.");
            generateEclipseJdtApt.setInputFile(project.file((Object)".settings/org.eclipse.jdt.apt.core.prefs"));
            generateEclipseJdtApt.setOutputFile(project.file((Object)".settings/org.eclipse.jdt.apt.core.prefs"));
            generateEclipseJdtApt.setJdtApt(jdtApt);
        });
        AptPlugin.IMPL.configureTask(project, Task.class, "eclipse", AptEclipsePlugin.dependsOn(task));
        Object cleanTask = AptPlugin.IMPL.createTask(project, "cleanEclipseJdtApt", Delete.class, cleanEclipseJdtApt -> cleanEclipseJdtApt.delete(new Object[]{task}));
        AptPlugin.IMPL.configureTask(project, Task.class, "cleanEclipse", AptEclipsePlugin.dependsOn(cleanTask));
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    private void configureFactorypath(Project project, EclipseModel eclipseModel, SourceSet mainSourceSet, SourceSet testSourceSet) {
        EclipseFactorypath factorypath = (EclipseFactorypath)((ExtensionAware)eclipseModel).getExtensions().create("factorypath", EclipseFactorypath.class, new Object[]{new XmlFileContentMerger(new XmlTransformer())});
        factorypath.setPlusConfigurations(new ArrayList<Configuration>(Arrays.asList(project.getConfigurations().getByName(AptPlugin.IMPL.getAnnotationProcessorConfigurationName(mainSourceSet)), project.getConfigurations().getByName(AptPlugin.IMPL.getAnnotationProcessorConfigurationName(testSourceSet)))));
        Object task = AptPlugin.IMPL.createTask(project, "eclipseFactorypath", GenerateEclipseFactorypath.class, generateEclipseFactorypath -> {
            generateEclipseFactorypath.setDescription("Generates the Eclipse factorypath file.");
            generateEclipseFactorypath.setInputFile(project.file((Object)".factorypath"));
            generateEclipseFactorypath.setOutputFile(project.file((Object)".factorypath"));
            generateEclipseFactorypath.setFactorypath(factorypath);
            generateEclipseFactorypath.dependsOn(factorypath.getPlusConfigurations().toArray());
        });
        AptPlugin.IMPL.configureTask(project, Task.class, "eclipse", AptEclipsePlugin.dependsOn(task));
        Object cleanTask = AptPlugin.IMPL.createTask(project, "cleanEclipseFactorypath", Delete.class, cleanEclipseFactorypath -> cleanEclipseFactorypath.delete(new Object[]{task}));
        AptPlugin.IMPL.configureTask(project, Task.class, "cleanEclipse", AptEclipsePlugin.dependsOn(cleanTask));
    }
}

