/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle;

import com.diffplug.common.base.Errors;
import com.diffplug.common.base.Joiner;
import com.diffplug.common.base.Preconditions;
import com.diffplug.common.base.Throwing;
import com.diffplug.common.collect.Maps;
import com.diffplug.common.io.Files;
import com.diffplug.common.swt.os.OS;
import com.diffplug.common.tree.TreeDef;
import com.diffplug.common.tree.TreeStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;

public class FileMisc {
    private static final int MS_RETRY = 500;
    private static final int OWNER_READ_FILEMODE = 256;
    private static final int OWNER_WRITE_FILEMODE = 128;
    private static final int OWNER_EXEC_FILEMODE = 64;
    private static final int GROUP_READ_FILEMODE = 32;
    private static final int GROUP_WRITE_FILEMODE = 16;
    private static final int GROUP_EXEC_FILEMODE = 8;
    private static final int OTHERS_READ_FILEMODE = 4;
    private static final int OTHERS_WRITE_FILEMODE = 2;
    private static final int OTHERS_EXEC_FILEMODE = 1;
    public static final String PROTOCOL = "file://" + (String)OS.getNative().winMacLinux((Object)"/", (Object)"", (Object)"");

    public static void download(String url, File dst) throws IOException {
        FileMisc.mkdirs(dst.getParentFile());
        OkHttpClient client = new OkHttpClient.Builder().build();
        Request req = new Request.Builder().url(url).build();
        try (Response response = client.newCall(req).execute();){
            if (!response.isSuccessful()) {
                ResponseBody body = response.body();
                throw new IllegalArgumentException(url + "\nreceived http code " + response.code() + (body == null ? "" : "\n" + body.string()));
            }
            try (ResponseBody body = response.body();
                 BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)dst));){
                if (body == null) {
                    throw new IllegalArgumentException("Body was expected to be non-null");
                }
                sink.writeAll((Source)body.source());
            }
        }
    }

    public static List<File> list(File d) {
        return (List)FileMisc.retry(d, dir -> {
            File[] children = dir.listFiles();
            if (children == null) {
                if (dir.isFile()) {
                    throw new IllegalArgumentException("Can't list " + dir + " because it is a file, not a directory.");
                }
                if (!dir.exists()) {
                    throw new IllegalArgumentException("Can't list " + dir + " because it does not exist.");
                }
                throw new IllegalArgumentException("Can't list " + dir + ", not sure why.");
            }
            return Arrays.asList(children);
        });
    }

    public static void mkdirs(File d) {
        FileMisc.retry(d, dir -> {
            java.nio.file.Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            return null;
        });
    }

    public static void forceDelete(File f) {
        FileMisc.retry(f, file -> {
            if (file.exists()) {
                FileUtils.forceDelete((File)f);
            }
            return null;
        });
    }

    private static <T> T retry(File input, Throwing.Function<File, T> function) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                return (T)function.apply((Object)input);
            }
            catch (Throwable e) {
                Throwable lastException = e;
                Errors.suppress().run(() -> Thread.sleep(1L));
                if (System.currentTimeMillis() - start < 500L) continue;
                throw Errors.asRuntime((Throwable)lastException);
            }
            break;
        }
    }

    public static boolean dirExists(File dir) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 500L) {
            File refreshed = (File)Errors.rethrow().get(dir::getCanonicalFile);
            if (refreshed.exists() && refreshed.isDirectory()) {
                return true;
            }
            Errors.rethrow().run(() -> Thread.sleep(1L));
        }
        return false;
    }

    public static String toUnixNewline(String input) {
        return input.replace("\r\n", "\n");
    }

    public static String quote(String input) {
        if (input.contains(" ")) {
            return "\"" + input + "\"";
        }
        return input;
    }

    public static String quote(File input) {
        return FileMisc.quote(input.getAbsolutePath());
    }

    public static String noQuote(String input) {
        if (input.contains(" ")) {
            throw new IllegalArgumentException("Cannot contain whitespace: '" + input + "'");
        }
        return input;
    }

    public static void writeToken(File dir, String name, String value) throws IOException {
        Preconditions.checkArgument((boolean)dir.isDirectory(), (String)"Need to create directory first!  %s", (Object[])new Object[]{dir});
        File token = new File(dir, name);
        FileUtils.write((File)token, (CharSequence)value, (Charset)StandardCharsets.UTF_8);
    }

    public static void writeTokenFile(File tokenFile, String value) throws IOException {
        FileMisc.writeToken(tokenFile.getParentFile(), tokenFile.getName(), value);
    }

    public static Optional<String> readToken(File dir, String name) throws IOException {
        File token = new File(dir, name);
        if (!token.isFile()) {
            return Optional.empty();
        }
        return Optional.of(FileUtils.readFileToString((File)token, (Charset)StandardCharsets.UTF_8));
    }

    public static void writeToken(File dir, String name) throws IOException {
        FileMisc.writeToken(dir, name, "");
    }

    public static boolean hasToken(File dir, String name) throws IOException {
        return FileMisc.readToken(dir, name).isPresent();
    }

    public static boolean hasToken(File dir, String name, String content) throws IOException {
        return FileMisc.readToken(dir, name).map(str -> content.equals(str)).orElse(false);
    }

    public static boolean hasTokenFile(File tokenFile) throws IOException {
        return FileMisc.hasToken(tokenFile.getParentFile(), tokenFile.getName());
    }

    public static boolean hasTokenFile(File tokenFile, String content) throws IOException {
        return FileMisc.hasToken(tokenFile.getParentFile(), tokenFile.getName(), content);
    }

    public static void copyFile(File srcFile, File dstFile, String ... toReplace) throws IOException {
        Preconditions.checkArgument((toReplace.length % 2 == 0 ? 1 : 0) != 0);
        HashMap replaceMap = Maps.newHashMap();
        for (int i = 0; i < toReplace.length / 2; ++i) {
            replaceMap.put(toReplace[2 * i], toReplace[2 * i + 1]);
        }
        String content = Joiner.on((String)"\n").join((Iterable)Files.readLines((File)srcFile, (Charset)StandardCharsets.UTF_8));
        for (Map.Entry entry : replaceMap.entrySet()) {
            content = content.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        FileMisc.mkdirs(dstFile.getParentFile());
        Files.write((byte[])content.getBytes(StandardCharsets.UTF_8), (File)dstFile);
    }

    public static void modifyFile(File file, Function<String, String> modifier) throws IOException {
        String content = new String(Files.toByteArray((File)file), StandardCharsets.UTF_8);
        String result = modifier.apply(content);
        Files.write((byte[])result.getBytes(StandardCharsets.UTF_8), (File)file);
    }

    public static void cleanDir(File dirToRemove) throws IOException {
        if (dirToRemove.isFile()) {
            FileMisc.forceDelete(dirToRemove);
        } else if (dirToRemove.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)dirToRemove);
            }
            catch (IOException e) {
                for (File file : FileMisc.list(dirToRemove)) {
                    FileMisc.forceDelete(file);
                }
            }
        }
        FileMisc.mkdirs(dirToRemove);
    }

    public static void flatten(File dirToRemove) throws IOException {
        File parent = dirToRemove.getParentFile();
        for (File child : FileMisc.list(dirToRemove)) {
            boolean createDestDir = false;
            if (child.isFile()) {
                FileUtils.moveFileToDirectory((File)child, (File)parent, (boolean)createDestDir);
                continue;
            }
            if (child.isDirectory()) {
                FileUtils.moveDirectoryToDirectory((File)child, (File)parent, (boolean)createDestDir);
                continue;
            }
            throw new IllegalArgumentException("Unknown filetype: " + child);
        }
        FileMisc.forceDelete(dirToRemove);
    }

    public static void concat(Iterable<File> toMerge, File dst) throws IOException {
        try (FileChannel dstChannel = FileChannel.open(dst.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            for (File file : toMerge) {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                Throwable throwable = null;
                try {
                    FileChannel channel = raf.getChannel();
                    dstChannel.write(channel.map(FileChannel.MapMode.READ_ONLY, 0L, raf.length()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (raf == null) continue;
                    if (throwable != null) {
                        try {
                            raf.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    raf.close();
                }
            }
        }
    }

    public static void deleteEmptyFolders(File d) throws IOException {
        FileMisc.retry(d, root -> {
            TreeDef dirTree = file -> Arrays.stream(file.listFiles()).filter(File::isDirectory).collect(Collectors.toList());
            List emptyDirs = TreeStream.depthFirst((TreeDef)dirTree, (Object)root).filter(dir -> dir.list().length == 0).collect(Collectors.toList());
            Iterator iterator = emptyDirs.iterator();
            block0: while (iterator.hasNext()) {
                File emptyDir;
                File toDelete = emptyDir = (File)iterator.next();
                while (!toDelete.equals(root)) {
                    Preconditions.checkArgument((boolean)toDelete.delete(), (String)"Failed to delete %s", (Object[])new Object[]{toDelete});
                    if ((toDelete = toDelete.getParentFile()).list().length <= 0) continue;
                    continue block0;
                }
            }
            return null;
        });
    }

    public static List<File> parseListFile(Project project, List<Object> inputs) {
        return inputs.stream().map(arg_0 -> ((Project)project).file(arg_0)).collect(Collectors.toList());
    }

    public static int toOctalFileModeInt(Set<PosixFilePermission> permissions) {
        int result = 0;
        for (PosixFilePermission permissionBit : permissions) {
            switch (permissionBit) {
                case OWNER_READ: {
                    result |= 0x100;
                    break;
                }
                case OWNER_WRITE: {
                    result |= 0x80;
                    break;
                }
                case OWNER_EXECUTE: {
                    result |= 0x40;
                    break;
                }
                case GROUP_READ: {
                    result |= 0x20;
                    break;
                }
                case GROUP_WRITE: {
                    result |= 0x10;
                    break;
                }
                case GROUP_EXECUTE: {
                    result |= 8;
                    break;
                }
                case OTHERS_READ: {
                    result |= 4;
                    break;
                }
                case OTHERS_WRITE: {
                    result |= 2;
                    break;
                }
                case OTHERS_EXECUTE: {
                    result |= 1;
                }
            }
        }
        return result;
    }

    public static String toOctalFileMode(Set<PosixFilePermission> permissions) {
        int value = FileMisc.toOctalFileModeInt(permissions);
        return Integer.toOctalString(value);
    }

    public static boolean containsExecutablePermission(Set<PosixFilePermission> permissions) {
        return permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE) && permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE) && permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE);
    }

    public static String asUrl(File file) {
        return PROTOCOL + file.getAbsolutePath();
    }

    public static String macApp() {
        return (String)OS.getNative().winMacLinux((Object)"", (Object)".app", (Object)"");
    }

    public static String macContentsEclipse() {
        return (String)OS.getNative().winMacLinux((Object)"", (Object)"Contents/Eclipse/", (Object)"");
    }

    public static void assertMacApp(File file) {
        if (OS.getNative().isMac()) {
            Preconditions.checkArgument((boolean)file.getName().endsWith(".app"), (Object)"Mac installations must end in .app");
        }
    }
}

