/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

final class TreeImp {
    private TreeImp() {
    }

    static <T> List<T> filteredList(List<T> unfiltered, Predicate<T> filter) {
        int numPassed = 0;
        for (T element : unfiltered) {
            if (!filter.test(element)) continue;
            ++numPassed;
        }
        if (numPassed == 0) {
            return Collections.emptyList();
        }
        if (numPassed == unfiltered.size()) {
            return unfiltered;
        }
        ArrayList<T> result = new ArrayList<T>(numPassed);
        for (T element : unfiltered) {
            if (!filter.test(element)) continue;
            result.add(element);
        }
        return result;
    }
}

