/*
 * Decompiled with CFR 0.152.
 */
package com.dieselpoint.norm.latency;

import com.dieselpoint.norm.Database;
import com.dieselpoint.norm.Query;
import com.dieselpoint.norm.Transaction;
import com.dieselpoint.norm.latency.DbLatencyWarning;

public class LatencyTimer {
    public final long startMillis;
    public long duration;
    public final long maxAcceptableLatency;
    public final Database db;

    public LatencyTimer(Query query) {
        this.db = query.getDatabase();
        this.startMillis = System.currentTimeMillis();
        this.maxAcceptableLatency = query.getMaxLatencyMillis();
    }

    public LatencyTimer(Transaction transaction) {
        this.db = transaction.getDatabase();
        this.startMillis = System.currentTimeMillis();
        this.maxAcceptableLatency = transaction.getMaxLatencyMillis();
    }

    private boolean stop() {
        if (this.maxAcceptableLatency < 0L) {
            return true;
        }
        this.duration = System.currentTimeMillis() - this.startMillis;
        if (this.maxAcceptableLatency == 0L) {
            return false;
        }
        return this.duration <= this.maxAcceptableLatency;
    }

    public boolean stop(String sql, Object[] args) {
        if (!this.stop() && this.db != null) {
            this.db.alertLatency(new DbLatencyWarning(this.maxAcceptableLatency, this.duration, sql, args));
        }
        return false;
    }

    public boolean stop(Transaction aTransaction) {
        if (!this.stop() && this.db != null) {
            this.db.alertLatency(new DbLatencyWarning(this.maxAcceptableLatency, this.duration, aTransaction));
        }
        return false;
    }
}

