/*
 * Decompiled with CFR 0.152.
 */
package com.dieselpoint.norm.latency;

import com.dieselpoint.norm.latency.DbLatencyWarning;
import com.dieselpoint.norm.latency.LatencyAlerter;
import java.time.Duration;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackoffLatencyAlerter
implements LatencyAlerter {
    private static final Logger logger = LoggerFactory.getLogger(BackoffLatencyAlerter.class);
    private final long minimumReportingLatencyMillis;
    private final long maximumReportingIntervalMillis;
    private long nextReportTime;
    private double backoffs;
    private long alertsSwallowedWhileWaiting = 0L;
    private final Random random = new Random();

    public BackoffLatencyAlerter(Duration minimumReportingInterval, Duration maximumReportingInterval) {
        this.minimumReportingLatencyMillis = minimumReportingInterval.toMillis();
        this.maximumReportingIntervalMillis = maximumReportingInterval.toMillis();
        this.backoffs = 1.0;
        this.nextReportTime = System.currentTimeMillis();
    }

    private long calculateWaitTime() {
        this.backoffs += this.alertsSwallowedWhileWaiting > 0L ? 1.0 : -0.25;
        this.backoffs = this.backoffs < 1.0 ? 1.0 : this.backoffs;
        long jitter = this.minimumReportingLatencyMillis / 2L - this.random.nextLong() % this.minimumReportingLatencyMillis;
        long timeToWait = this.minimumReportingLatencyMillis * (long)Math.pow(2.0, this.backoffs) + jitter;
        if (timeToWait > this.maximumReportingIntervalMillis) {
            this.backoffs -= 1.0;
        }
        return timeToWait;
    }

    @Override
    public synchronized void alertLatencyFailure(DbLatencyWarning warning) {
        if (warning.maxAcceptableLatency != 0L) {
            long myTime = System.currentTimeMillis();
            if (this.nextReportTime <= myTime) {
                if (!this.alertLatencyFailureAfterBackoffAndJitter(warning, this.alertsSwallowedWhileWaiting)) {
                    ++this.alertsSwallowedWhileWaiting;
                }
                this.nextReportTime = myTime + this.calculateWaitTime();
                this.alertsSwallowedWhileWaiting = 0L;
            } else {
                logger.info("Swallowed latency failure:" + warning);
                ++this.alertsSwallowedWhileWaiting;
            }
        }
    }

    public abstract boolean alertLatencyFailureAfterBackoffAndJitter(DbLatencyWarning var1, long var2);
}

