/*
 * Decompiled with CFR 0.152.
 */
package com.dieselpoint.norm;

import com.dieselpoint.norm.Database;
import com.dieselpoint.norm.DbException;
import com.dieselpoint.norm.Transaction;
import com.dieselpoint.norm.Util;
import com.dieselpoint.norm.latency.LatencyTimer;
import com.dieselpoint.norm.sqlmakers.PojoInfo;
import com.dieselpoint.norm.sqlmakers.SqlMaker;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Query {
    private Object generatedKeyReceiver;
    private String[] generatedKeyNames;
    private String sql;
    private String table;
    private String where;
    private String orderBy;
    private Object[] args;
    private int rowsAffected;
    private ResultSetMetaData meta;
    private Database db;
    private SqlMaker sqlMaker;
    private long maxLatency;
    private Transaction transaction;

    public Query(Database db) {
        this.db = db;
        this.sqlMaker = db.getSqlMaker();
        this.maxLatency(db.getMaxLatencyMillis());
    }

    public Query where(String where, Object ... args) {
        this.where = where;
        this.args = args;
        return this;
    }

    public Query sql(String sql, Object ... args) {
        this.sql = sql;
        this.args = args;
        return this;
    }

    public Query sql(String sql, List<?> args) {
        this.sql = sql;
        this.args = args.toArray();
        return this;
    }

    public Query orderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public <T> T first(Class<T> clazz) {
        List<T> list = this.results(clazz);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    private List<Map<String, Object>> resultsMap(Class<Map<String, Object>> clazz) {
        ArrayList<Map<String, Object>> out = new ArrayList<Map<String, Object>>();
        Connection con = null;
        PreparedStatement state = null;
        try {
            Connection localCon;
            if (this.sql == null) {
                this.sql = this.sqlMaker.getSelectSql(this, clazz);
            }
            if (this.transaction == null) {
                con = localCon = this.db.getConnection();
            } else {
                localCon = this.transaction.getConnection();
            }
            state = localCon.prepareStatement(this.sql);
            this.loadArgs(state);
            LatencyTimer myTimer = new LatencyTimer(this);
            ResultSet rs = state.executeQuery();
            myTimer.stop(this.sql, this.args);
            this.meta = rs.getMetaData();
            int colCount = this.meta.getColumnCount();
            while (rs.next()) {
                Map<String, Object> map = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (int i = 1; i <= colCount; ++i) {
                    String colName = this.meta.getColumnLabel(i);
                    map.put(colName, rs.getObject(i));
                }
                out.add(map);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | SQLException e) {
            try {
                throw new DbException(e);
            }
            catch (Throwable throwable) {
                this.close(state);
                this.close(con);
                throw throwable;
            }
        }
        this.close(state);
        this.close(con);
        return out;
    }

    public <T> List<T> results(Class<T> clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            return this.resultsMap(clazz);
        }
        ArrayList<Object> out = new ArrayList<Object>();
        Connection con = null;
        PreparedStatement state = null;
        try {
            Connection localCon;
            if (this.sql == null) {
                this.sql = this.sqlMaker.getSelectSql(this, clazz);
            }
            if (this.transaction == null) {
                con = localCon = this.db.getConnection();
            } else {
                localCon = this.transaction.getConnection();
            }
            state = localCon.prepareStatement(this.sql);
            this.loadArgs(state);
            LatencyTimer myLatencyTimer = new LatencyTimer(this);
            ResultSet rs = state.executeQuery();
            myLatencyTimer.stop(this.sql, this.args);
            this.meta = rs.getMetaData();
            int colCount = this.meta.getColumnCount();
            if (Util.isPrimitiveOrString(clazz) || clazz.getPackage().getName().startsWith("java.sql")) {
                while (rs.next()) {
                    Object colValue = rs.getObject(1);
                    out.add(colValue);
                }
            } else {
                PojoInfo pojoInfo = this.sqlMaker.getPojoInfo(clazz);
                while (rs.next()) {
                    Map<String, Object> row = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    for (int i = 1; i <= colCount; ++i) {
                        String colName = this.meta.getColumnLabel(i);
                        Object colValue = this.sqlMaker.convertValue(rs.getObject(i), this.meta.getColumnTypeName(i));
                        pojoInfo.putValue(row, colName, colValue, true);
                    }
                    out.add(row);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | SQLException e) {
            try {
                DbException dbe = new DbException(e);
                dbe.setSql(this.sql);
                throw dbe;
            }
            catch (Throwable throwable) {
                this.close(state);
                this.close(con);
                throw throwable;
            }
        }
        this.close(state);
        this.close(con);
        return out;
    }

    private void loadArgs(PreparedStatement state) throws SQLException {
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                state.setObject(i + 1, this.args[i]);
            }
        }
    }

    private void close(AutoCloseable ac) {
        if (ac == null) {
            return;
        }
        try {
            ac.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Query insert(Object row) {
        PojoInfo pojoInfo;
        String[] names;
        if (this.generatedKeyReceiver == null && (names = (pojoInfo = this.sqlMaker.getPojoInfo(row.getClass())).getGeneratedColumnNames()).length != 0) {
            this.generatedKeyReceiver = row;
            this.generatedKeyNames = names;
        }
        this.sql = this.sqlMaker.getInsertSql(this, row);
        this.args = this.sqlMaker.getInsertArgs(this, row);
        this.execute();
        return this;
    }

    public Query upsert(Object row) {
        this.sql = this.sqlMaker.getUpsertSql(this, row);
        this.args = this.sqlMaker.getUpsertArgs(this, row);
        this.execute();
        return this;
    }

    public Query update(Object row) {
        this.sql = this.sqlMaker.getUpdateSql(this, row);
        this.args = this.sqlMaker.getUpdateArgs(this, row);
        if (this.execute().getRowsAffected() <= 0) {
            throw new DbException("Row not updated because the primary key was not found");
        }
        return this;
    }

    public Query execute() {
        Connection con = null;
        PreparedStatement state = null;
        try {
            Connection localCon;
            if (this.transaction == null) {
                con = localCon = this.db.getConnection();
            } else {
                localCon = this.transaction.getConnection();
            }
            state = this.generatedKeyReceiver != null ? localCon.prepareStatement(this.sql, 1) : localCon.prepareStatement(this.sql);
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    Object[] arg = this.args[i];
                    if (arg != null && List.class.isAssignableFrom(arg.getClass())) {
                        arg = ((List)arg).toArray();
                    }
                    state.setObject(i + 1, arg);
                }
            }
            LatencyTimer myTimer = new LatencyTimer(this);
            this.rowsAffected = state.executeUpdate();
            myTimer.stop(this.sql, this.args);
            if (this.generatedKeyReceiver != null) {
                this.populateGeneratedKeys(state, this.generatedKeyReceiver, this.generatedKeyNames);
            }
        }
        catch (IllegalArgumentException | SQLException e) {
            try {
                DbException dbe = new DbException(e);
                dbe.setSql(this.sql);
                throw dbe;
            }
            catch (Throwable throwable) {
                this.close(state);
                this.close(con);
                throw throwable;
            }
        }
        this.close(state);
        this.close(con);
        return this;
    }

    private void populateGeneratedKeys(PreparedStatement state, Object generatedKeyReceiver, String[] generatedKeyNames) {
        ResultSet rs = null;
        try {
            boolean isMap = Map.class.isAssignableFrom(generatedKeyReceiver.getClass());
            PojoInfo pojoInfo = null;
            if (!isMap) {
                pojoInfo = this.sqlMaker.getPojoInfo(generatedKeyReceiver.getClass());
            }
            rs = state.getGeneratedKeys();
            ResultSetMetaData meta = rs.getMetaData();
            int colCount = meta.getColumnCount();
            if (rs.next()) {
                if (isMap) {
                    Map map = (Map)generatedKeyReceiver;
                    if (colCount == 1) {
                        map.put(generatedKeyNames[0], rs.getObject(1));
                    } else {
                        for (String generatedKeyName : generatedKeyNames) {
                            map.put(generatedKeyName, rs.getObject(generatedKeyName));
                        }
                    }
                } else {
                    for (String generatedKeyName : generatedKeyNames) {
                        Object value = colCount == 1 ? rs.getObject(1) : rs.getObject(generatedKeyName);
                        pojoInfo.putValue(generatedKeyReceiver, generatedKeyName, value);
                    }
                }
            }
        }
        catch (IllegalArgumentException | SecurityException | SQLException e) {
            throw new DbException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public Query generatedKeyReceiver(Object generatedKeyReceiver, String ... generatedKeyNames) {
        this.generatedKeyReceiver = generatedKeyReceiver;
        this.generatedKeyNames = generatedKeyNames;
        return this;
    }

    public Query createTable(Class<?> clazz) {
        this.sql = this.sqlMaker.getCreateTableSql(clazz);
        this.execute();
        return this;
    }

    public Query delete(Object row) {
        this.sql = this.sqlMaker.getDeleteSql(this, row);
        this.args = this.sqlMaker.getDeleteArgs(this, row);
        this.execute();
        return this;
    }

    public Query delete() {
        String table = this.getTable();
        if (table == null) {
            throw new DbException("You must specify a table name with the table() method.");
        }
        this.sql = "delete from " + table;
        if (this.where != null) {
            this.sql = this.sql + " where " + this.where;
        }
        this.execute();
        return this;
    }

    public Query table(String table) {
        this.table = table;
        return this;
    }

    public int getRowsAffected() {
        return this.rowsAffected;
    }

    public Query transaction(Transaction trans) {
        this.transaction = trans;
        return this;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getWhere() {
        return this.where;
    }

    public String getTable() {
        return this.table;
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.meta;
    }

    public long getMaxLatencyMillis() {
        return this.maxLatency;
    }

    public Query maxLatency(long millis) {
        this.maxLatency = millis;
        return this;
    }

    public Database getDatabase() {
        return this.db;
    }
}

