/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data;

import io.stargate.sdk.data.CollectionClient;
import io.stargate.sdk.data.CollectionRepository;
import io.stargate.sdk.data.DataApiClient;
import io.stargate.sdk.data.domain.ApiResponse;
import io.stargate.sdk.data.domain.CollectionDefinition;
import io.stargate.sdk.data.domain.SimilarityMetric;
import io.stargate.sdk.data.exception.DataApiCollectionNotFoundException;
import io.stargate.sdk.data.utils.DataApiUtils;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.utils.AnsiUtils;
import io.stargate.sdk.utils.Assert;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceClient {
    private static final Logger log = LoggerFactory.getLogger(NamespaceClient.class);
    protected final LoadBalancedHttpClient stargateHttpClient;
    private String namespace;
    public final Function<ServiceHttp, String> namespaceResource = node -> DataApiClient.rootResource.apply((ServiceHttp)node) + "/" + this.namespace;

    public NamespaceClient(LoadBalancedHttpClient httpClient, String namespace) {
        this.namespace = namespace;
        this.stargateHttpClient = httpClient;
        Assert.notNull((Object)namespace, (String)"namespace");
    }

    public boolean isCollectionExists(String collection) {
        return this.findCollections().map(CollectionDefinition::getName).anyMatch(collection::equals);
    }

    public Stream<CollectionDefinition> findCollections() {
        return this.execute("findCollections", Map.of("options", Map.of("explain", true))).getStatusKeyAsList("collections", CollectionDefinition.class).stream();
    }

    public CollectionClient createCollection(String collection) {
        return this.createCollection(CollectionDefinition.builder().name(collection).build());
    }

    public <DOC> CollectionRepository<DOC> createCollection(String collection, Class<DOC> clazz) {
        return this.createCollection(CollectionDefinition.builder().name(collection).build(), clazz);
    }

    public CollectionClient createCollection(String collection, int dimension) {
        return this.createCollection(CollectionDefinition.builder().name(collection).vector(dimension, SimilarityMetric.cosine).build());
    }

    public CollectionClient createCollection(CollectionDefinition req) {
        this.execute("createCollection", req);
        log.info("Collection  '" + AnsiUtils.green((String)"{}") + "' has been created", (Object)req.getName());
        return new CollectionClient(this.stargateHttpClient, this.namespace, req.getName());
    }

    public <DOC> CollectionRepository<DOC> createCollection(CollectionDefinition req, Class<DOC> clazz) {
        this.execute("createCollection", req);
        log.info("Collection  '" + AnsiUtils.green((String)"{}") + "' has been created", (Object)req.getName());
        return this.collectionRepository(req.getName(), clazz);
    }

    public void deleteCollection(String collection) {
        this.execute("deleteCollection", Map.of("name", collection));
        log.info("Collection  '" + AnsiUtils.green((String)"{}") + "' has been deleted", (Object)collection);
    }

    private ApiResponse execute(String operation, Object payload) {
        return DataApiUtils.executeOperation(this.stargateHttpClient, this.namespaceResource, operation, payload);
    }

    public Optional<CollectionDefinition> findCollectionByName(String collectionName) {
        return this.findCollections().filter(collection -> collection.getName().equals(collectionName)).findFirst();
    }

    public CollectionClient collection(String collectionName) {
        if (this.findCollections().map(CollectionDefinition::getName).noneMatch(collectionName::equals)) {
            throw new DataApiCollectionNotFoundException(collectionName);
        }
        return new CollectionClient(this.stargateHttpClient, this.namespace, collectionName);
    }

    public <T> CollectionRepository<T> collectionRepository(String collectionName, Class<T> clazz) {
        if (!this.isCollectionExists(collectionName)) {
            throw new DataApiCollectionNotFoundException(collectionName);
        }
        return new CollectionRepository<T>(this.collection(collectionName), clazz);
    }

    public LoadBalancedHttpClient getStargateHttpClient() {
        return this.stargateHttpClient;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Function<ServiceHttp, String> getNamespaceResource() {
        return this.namespaceResource;
    }
}

