/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.session;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.testinfra.CassandraResourceRule;
import com.datastax.oss.driver.api.testinfra.session.SessionRule;
import com.datastax.oss.driver.api.testinfra.session.SessionRuleBuilder;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;

public class CqlSessionRuleBuilder
extends SessionRuleBuilder<CqlSessionRuleBuilder, CqlSession> {
    private static final AtomicInteger GRAPH_NAME_INDEX = new AtomicInteger();

    public CqlSessionRuleBuilder(CassandraResourceRule cassandraResource) {
        super(cassandraResource);
    }

    @Override
    public SessionRule<CqlSession> build() {
        Supplier<Config> actualSupplier;
        String graphName;
        if (this.createGraph) {
            graphName = "dsedrivertests_" + GRAPH_NAME_INDEX.getAndIncrement();
            if (this.loader == null) {
                this.loader = new DefaultDriverConfigLoader();
            } else {
                Assertions.assertThat((Object)this.loader).isInstanceOf(DefaultDriverConfigLoader.class);
            }
            Supplier originalSupplier = ((DefaultDriverConfigLoader)this.loader).getConfigSupplier();
            actualSupplier = () -> CqlSessionRuleBuilder.lambda$build$0((Supplier)originalSupplier, graphName);
        } else {
            graphName = null;
            if (this.loader == null) {
                this.loader = new DefaultDriverConfigLoader();
            }
            actualSupplier = ((DefaultDriverConfigLoader)this.loader).getConfigSupplier();
        }
        DefaultDriverConfigLoader actualLoader = new DefaultDriverConfigLoader(() -> this.lambda$build$1((Supplier)actualSupplier));
        return new SessionRule<CqlSession>(this.cassandraResource, this.createKeyspace, this.nodeStateListener, this.schemaChangeListener, (DriverConfigLoader)actualLoader, graphName, this.isCoreGraph);
    }

    private /* synthetic */ Config lambda$build$1(Supplier actualSupplier) {
        return this.graphProtocol != null ? ((Config)actualSupplier.get()).withValue(DseDriverOption.GRAPH_SUB_PROTOCOL.getPath(), ConfigValueFactory.fromAnyRef((Object)this.graphProtocol)) : (Config)actualSupplier.get();
    }

    private static /* synthetic */ Config lambda$build$0(Supplier originalSupplier, String graphName) {
        return ((Config)originalSupplier.get()).withValue(DseDriverOption.GRAPH_NAME.getPath(), ConfigValueFactory.fromAnyRef((Object)graphName));
    }
}

