/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.loadbalancing;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.testinfra.loadbalancing.NodeComparator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

public class SortingLoadBalancingPolicy
implements LoadBalancingPolicy {
    private final Set<Node> nodes = new TreeSet<Node>(NodeComparator.INSTANCE);

    public SortingLoadBalancingPolicy(DriverContext context, String profileName) {
    }

    public SortingLoadBalancingPolicy() {
    }

    public void init(@NonNull Map<UUID, Node> nodes, @NonNull LoadBalancingPolicy.DistanceReporter distanceReporter) {
        this.nodes.addAll(nodes.values());
        this.nodes.forEach(n -> distanceReporter.setDistance(n, NodeDistance.LOCAL));
    }

    @NonNull
    public Queue<Node> newQueryPlan(@Nullable Request request, @Nullable Session session) {
        return new ArrayDeque<Node>(this.nodes);
    }

    public void onAdd(@NonNull Node node) {
        this.nodes.add(node);
    }

    public void onUp(@NonNull Node node) {
        this.onAdd(node);
    }

    public void onDown(@NonNull Node node) {
        this.onRemove(node);
    }

    public void onRemove(@NonNull Node node) {
        this.nodes.remove(node);
    }

    public void close() {
    }
}

