/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.BindableHandlingSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.PropertyType;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class EntityHelperGetMethodGenerator
implements MethodGenerator {
    private final EntityDefinition entityDefinition;
    private final BindableHandlingSharedCode enclosingClass;

    public EntityHelperGetMethodGenerator(EntityDefinition entityDefinition, BindableHandlingSharedCode enclosingClass) {
        this.entityDefinition = entityDefinition;
        this.enclosingClass = enclosingClass;
    }

    @Override
    public Optional<MethodSpec> generate() {
        MethodSpec.Builder getBuilder = MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(GettableByName.class), (String)"source", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)TypeName.BOOLEAN, (String)"lenient", (Modifier[])new Modifier[0]).build()).returns((TypeName)this.entityDefinition.getClassName());
        ClassName returnType = this.entityDefinition.getClassName();
        String resultName = "returnValue";
        boolean mutable = this.entityDefinition.isMutable();
        if (mutable) {
            getBuilder.addStatement("$1T $2L = new $1T()", new Object[]{returnType, resultName});
        }
        ArrayList<String> propertyValueNames = new ArrayList<String>();
        for (PropertyDefinition property : this.entityDefinition.getAllValues()) {
            PropertyType type = property.getType();
            CodeBlock cqlName = property.getCqlName();
            String setterName = property.getSetterName();
            String propertyValueName = this.enclosingClass.getNameIndex().uniqueField("propertyValue");
            propertyValueNames.add(propertyValueName);
            if (type instanceof PropertyType.Simple) {
                TypeName typeName = ((PropertyType.Simple)type).typeName;
                String primitiveAccessor = GeneratedCodePatterns.PRIMITIVE_ACCESSORS.get(typeName);
                if (primitiveAccessor != null) {
                    if (mutable) {
                        getBuilder.beginControlFlow("if (!lenient || hasProperty(source, $L))", new Object[]{cqlName}).addStatement("$T $L = source.get$L($L)", new Object[]{typeName, propertyValueName, primitiveAccessor, cqlName}).addStatement("$L.$L($L)", new Object[]{resultName, setterName, propertyValueName}).endControlFlow();
                        continue;
                    }
                    getBuilder.addStatement("$T $L = !lenient || hasProperty(source, $L) ? source.get$L($L) : $L", new Object[]{typeName, propertyValueName, cqlName, primitiveAccessor, cqlName, typeName.equals((Object)TypeName.BOOLEAN) ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0)});
                    continue;
                }
                if (typeName instanceof ClassName) {
                    if (mutable) {
                        getBuilder.beginControlFlow("if (!lenient || hasProperty(source, $L))", new Object[]{cqlName}).addStatement("$T $L = source.get($L, $T.class)", new Object[]{typeName, propertyValueName, cqlName, typeName}).addStatement("$L.$L($L)", new Object[]{resultName, setterName, propertyValueName}).endControlFlow();
                        continue;
                    }
                    getBuilder.addStatement("$T $L = !lenient || hasProperty(source, $L) ? source.get($L, $T.class) : null", new Object[]{typeName, propertyValueName, cqlName, cqlName, typeName});
                    continue;
                }
                if (mutable) {
                    getBuilder.beginControlFlow("if (!lenient || hasProperty(source, $L))", new Object[]{cqlName}).addStatement("$T $L = source.get($L, $L)", new Object[]{typeName, propertyValueName, cqlName, this.enclosingClass.addGenericTypeConstant(typeName)}).addStatement("$L.$L($L)", new Object[]{resultName, setterName, propertyValueName}).endControlFlow();
                    continue;
                }
                getBuilder.addStatement("$T $L = !lenient || hasProperty(source, $L) ? source.get($L, $L) : null", new Object[]{typeName, propertyValueName, cqlName, cqlName, this.enclosingClass.addGenericTypeConstant(typeName)});
                continue;
            }
            if (type instanceof PropertyType.SingleEntity) {
                ClassName entityClass = ((PropertyType.SingleEntity)type).entityName;
                String udtValueName = this.enclosingClass.getNameIndex().uniqueField("udtValue");
                if (mutable) {
                    getBuilder.beginControlFlow("if (!lenient || hasProperty(source, $L))", new Object[]{cqlName});
                    getBuilder.addStatement("$T $L", new Object[]{entityClass, propertyValueName});
                } else {
                    getBuilder.addStatement("$T $L = null", new Object[]{entityClass, propertyValueName});
                    getBuilder.beginControlFlow("if (!lenient || hasProperty(source, $L))", new Object[]{cqlName});
                }
                getBuilder.addStatement("$T $L = source.getUdtValue($L)", new Object[]{UdtValue.class, udtValueName, cqlName});
                String childHelper = this.enclosingClass.addEntityHelperField(entityClass);
                getBuilder.addStatement("$L = $L == null ? null : $L.get($L, lenient)", new Object[]{propertyValueName, udtValueName, childHelper, udtValueName});
                if (mutable) {
                    getBuilder.addStatement("$L.$L($L)", new Object[]{resultName, setterName, propertyValueName});
                }
                getBuilder.endControlFlow();
                continue;
            }
            if (mutable) {
                getBuilder.beginControlFlow("if (!lenient || hasProperty(source, $L))", new Object[]{cqlName});
                getBuilder.addStatement("$T $L", new Object[]{type.asTypeName(), propertyValueName});
            } else {
                getBuilder.addStatement("$T $L = null", new Object[]{type.asTypeName(), propertyValueName});
                getBuilder.beginControlFlow("if (!lenient || hasProperty(source, $L))", new Object[]{cqlName});
            }
            String rawCollectionName = this.enclosingClass.getNameIndex().uniqueField("rawCollection");
            TypeName rawCollectionType = type.asRawTypeName();
            getBuilder.addStatement("$T $L = source.get($L, $L)", new Object[]{rawCollectionType, rawCollectionName, cqlName, this.enclosingClass.addGenericTypeConstant(rawCollectionType)});
            getBuilder.beginControlFlow("if ($L == null)", new Object[]{rawCollectionName}).addStatement("$L = null", new Object[]{propertyValueName}).nextControlFlow("else", new Object[0]);
            this.convertUdtsIntoEntities(rawCollectionName, propertyValueName, type, getBuilder);
            getBuilder.endControlFlow();
            if (mutable) {
                getBuilder.addStatement("$L.$L($L)", new Object[]{resultName, setterName, propertyValueName});
            }
            getBuilder.endControlFlow();
        }
        if (mutable) {
            getBuilder.addStatement("return returnValue", new Object[0]);
        } else {
            getBuilder.addCode("$[return new $T(", new Object[]{returnType});
            for (int i = 0; i < propertyValueNames.size(); ++i) {
                getBuilder.addCode(i == 0 ? "\n$L" : ",\n$L", new Object[]{propertyValueNames.get(i)});
            }
            getBuilder.addCode(")$];", new Object[0]);
        }
        return Optional.of(getBuilder.build());
    }

    private void convertUdtsIntoEntities(String rawObjectName, String mappedObjectName, PropertyType type, MethodSpec.Builder getBuilder) {
        if (type instanceof PropertyType.SingleEntity) {
            ClassName entityClass = ((PropertyType.SingleEntity)type).entityName;
            String entityHelperName = this.enclosingClass.addEntityHelperField(entityClass);
            getBuilder.addStatement("$L = $L.get($L, lenient)", new Object[]{mappedObjectName, entityHelperName, rawObjectName});
        } else if (type instanceof PropertyType.EntityList) {
            getBuilder.addStatement("$L = $T.newArrayListWithExpectedSize($L.size())", new Object[]{mappedObjectName, Lists.class, rawObjectName});
            PropertyType mappedElementType = ((PropertyType.EntityList)type).elementType;
            TypeName rawElementType = mappedElementType.asRawTypeName();
            String rawElementName = this.enclosingClass.getNameIndex().uniqueField("rawElement");
            getBuilder.beginControlFlow("for ($T $L: $L)", new Object[]{rawElementType, rawElementName, rawObjectName});
            String mappedElementName = this.enclosingClass.getNameIndex().uniqueField("mappedElement");
            getBuilder.addStatement("$T $L", new Object[]{mappedElementType.asTypeName(), mappedElementName});
            this.convertUdtsIntoEntities(rawElementName, mappedElementName, mappedElementType, getBuilder);
            getBuilder.addStatement("$L.add($L)", new Object[]{mappedObjectName, mappedElementName}).endControlFlow();
        } else if (type instanceof PropertyType.EntitySet) {
            getBuilder.addStatement("$L = $T.newLinkedHashSetWithExpectedSize($L.size())", new Object[]{mappedObjectName, Sets.class, rawObjectName});
            PropertyType mappedElementType = ((PropertyType.EntitySet)type).elementType;
            TypeName rawElementType = mappedElementType.asRawTypeName();
            String rawElementName = this.enclosingClass.getNameIndex().uniqueField("rawElement");
            getBuilder.beginControlFlow("for ($T $L: $L)", new Object[]{rawElementType, rawElementName, rawObjectName});
            String mappedElementName = this.enclosingClass.getNameIndex().uniqueField("mappedElement");
            getBuilder.addStatement("$T $L", new Object[]{mappedElementType.asTypeName(), mappedElementName});
            this.convertUdtsIntoEntities(rawElementName, mappedElementName, mappedElementType, getBuilder);
            getBuilder.addStatement("$L.add($L)", new Object[]{mappedObjectName, mappedElementName}).endControlFlow();
        } else if (type instanceof PropertyType.EntityMap) {
            String mappedValueName;
            String mappedKeyName;
            getBuilder.addStatement("$L = $T.newLinkedHashMapWithExpectedSize($L.size())", new Object[]{mappedObjectName, Maps.class, rawObjectName});
            PropertyType mappedKeyType = ((PropertyType.EntityMap)type).keyType;
            PropertyType mappedValueType = ((PropertyType.EntityMap)type).valueType;
            String rawEntryName = this.enclosingClass.getNameIndex().uniqueField("rawEntry");
            getBuilder.beginControlFlow("for ($T $L: $L.entrySet())", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.Entry.class), (TypeName[])new TypeName[]{mappedKeyType.asRawTypeName(), mappedValueType.asRawTypeName()}), rawEntryName, rawObjectName});
            String rawKeyName = CodeBlock.of((String)"$L.getKey()", (Object[])new Object[]{rawEntryName}).toString();
            if (mappedKeyType instanceof PropertyType.Simple) {
                mappedKeyName = rawKeyName;
            } else {
                mappedKeyName = this.enclosingClass.getNameIndex().uniqueField("mappedKey");
                getBuilder.addStatement("$T $L", new Object[]{mappedKeyType.asTypeName(), mappedKeyName});
                this.convertUdtsIntoEntities(rawKeyName, mappedKeyName, mappedKeyType, getBuilder);
            }
            String rawValueName = CodeBlock.of((String)"$L.getValue()", (Object[])new Object[]{rawEntryName}).toString();
            if (mappedValueType instanceof PropertyType.Simple) {
                mappedValueName = rawValueName;
            } else {
                mappedValueName = this.enclosingClass.getNameIndex().uniqueField("mappedValue");
                getBuilder.addStatement("$T $L", new Object[]{mappedValueType.asTypeName(), mappedValueName});
                this.convertUdtsIntoEntities(rawValueName, mappedValueName, mappedValueType, getBuilder);
            }
            getBuilder.addStatement("$L.put($L, $L)", new Object[]{mappedObjectName, mappedKeyName, mappedValueName}).endControlFlow();
        } else {
            throw new AssertionError((Object)("Unsupported type " + type.asTypeName()));
        }
    }
}

