/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.utils;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.dsbulk.workflow.api.utils.WorkflowUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowUtils.class);
    private static final Version DSE_NATIVE_GRAPH_MIN_VERSION = Version.parse((String)"6.8.0");

    public static void checkGraphCompatibility(Session session) {
        Collection nodes = session.getMetadata().getNodes().values();
        List nonGraphNodes = nodes.stream().filter(node -> !node.getExtras().containsKey("DSE_VERSION") || ((Version)node.getExtras().get("DSE_VERSION")).compareTo(Objects.requireNonNull(DSE_NATIVE_GRAPH_MIN_VERSION)) < 0).collect(Collectors.toList());
        if (!nonGraphNodes.isEmpty()) {
            LOGGER.error("Incompatible cluster detected. Graph functionality is only compatible with DSE {} or higher.", (Object)DSE_NATIVE_GRAPH_MIN_VERSION);
            LOGGER.error("The following nodes do not appear to be running DSE {} or higher:", (Object)DSE_NATIVE_GRAPH_MIN_VERSION);
            for (Node node2 : nonGraphNodes) {
                LOGGER.error(node2.toString());
            }
            throw new IllegalStateException("Graph operations not available due to incompatible cluster");
        }
    }
}

