/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.utils;

import com.datastax.oss.driver.shaded.guava.common.base.Throwables;
import edu.umd.cs.findbugs.annotations.Nullable;
import reactor.core.Disposable;

public class CloseableUtils {
    @Nullable
    public static Exception closeQuietly(@Nullable AutoCloseable closeable, @Nullable Exception suppressed) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                if (suppressed != null) {
                    e.addSuppressed(suppressed);
                }
                return e;
            }
        }
        return suppressed;
    }

    @Nullable
    public static Exception closeQuietly(@Nullable Disposable disposable, @Nullable Exception suppressed) {
        if (disposable != null && !disposable.isDisposed()) {
            try {
                disposable.dispose();
            }
            catch (Exception e) {
                Throwable root = Throwables.getRootCause((Throwable)e);
                if (root instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (suppressed != null) {
                    e.addSuppressed(suppressed);
                }
                return e;
            }
        }
        return suppressed;
    }
}

