/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.utils;

import com.datastax.oss.driver.shaded.guava.common.net.InetAddresses;
import edu.umd.cs.findbugs.annotations.NonNull;

public class AddressUtils {
    @NonNull
    public static String maybeAddPortToHost(@NonNull String contactPoint, int defaultPort) {
        int colon = contactPoint.lastIndexOf(58);
        if (colon == -1) {
            return contactPoint + ':' + defaultPort;
        }
        String hostOrIp = contactPoint.substring(0, colon);
        if (hostOrIp.indexOf(58) != -1) {
            boolean contactPointOk = InetAddresses.isInetAddress((String)contactPoint);
            boolean hostOrIpOk = InetAddresses.isInetAddress((String)hostOrIp);
            if (!contactPointOk && hostOrIpOk) {
                return contactPoint;
            }
            if (contactPointOk && !hostOrIpOk) {
                return contactPoint + ':' + defaultPort;
            }
            try {
                Integer.parseInt(contactPoint.substring(colon + 1));
            }
            catch (NumberFormatException e) {
                return contactPoint + ':' + defaultPort;
            }
        }
        return contactPoint;
    }
}

