/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.ssl;

import com.datastax.oss.driver.api.core.ssl.ProgrammaticSslEngineFactory;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.internal.core.ssl.JdkSslHandlerFactory;
import com.datastax.oss.driver.internal.core.ssl.SslHandlerFactory;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.io.IOUtils;
import com.datastax.oss.dsbulk.workflow.commons.ssl.NettySslHandlerFactory;
import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SslHandlerFactoryFactory {
    @Nullable
    public static SslHandlerFactory createSslHandlerFactory(Config config) throws GeneralSecurityException, IOException {
        String sslProvider = config.getString("provider");
        switch (sslProvider.toLowerCase()) {
            case "none": {
                return null;
            }
            case "jdk": {
                return SslHandlerFactoryFactory.createJdkSslHandlerFactory(config);
            }
            case "openssl": {
                return SslHandlerFactoryFactory.createNettySslHandlerFactory(config);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid value for dsbulk.driver.ssl.provider, expecting None, JDK, or OpenSSL, got: '%s'", sslProvider));
    }

    private static SslHandlerFactory createJdkSslHandlerFactory(Config config) throws GeneralSecurityException, IOException {
        KeyManagerFactory kmf = SslHandlerFactoryFactory.createKeyManagerFactory(config);
        TrustManagerFactory tmf = SslHandlerFactoryFactory.createTrustManagerFactory(config);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf != null ? kmf.getKeyManagers() : null, tmf != null ? tmf.getTrustManagers() : null, new SecureRandom());
        List cipherSuites = config.getStringList("cipherSuites");
        ProgrammaticSslEngineFactory sslEngineFactory = new ProgrammaticSslEngineFactory(sslContext, cipherSuites.isEmpty() ? null : cipherSuites.toArray(new String[0]), true);
        return new JdkSslHandlerFactory((SslEngineFactory)sslEngineFactory);
    }

    private static SslHandlerFactory createNettySslHandlerFactory(Config config) throws GeneralSecurityException, IOException {
        List cipherSuites;
        if (config.hasPath("openssl.keyCertChain") != config.hasPath("openssl.privateKey")) {
            throw new IllegalArgumentException("Settings dsbulk.driver.ssl.openssl.keyCertChain and dsbulk.driver.ssl.openssl.privateKey must be provided together or not at all when using the OpenSSL provider");
        }
        TrustManagerFactory tmf = SslHandlerFactoryFactory.createTrustManagerFactory(config);
        SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).trustManager(tmf);
        if (config.hasPath("openssl.keyCertChain")) {
            Path sslOpenSslKeyCertChain = ConfigUtils.getPath((Config)config, (String)"openssl.keyCertChain");
            Path sslOpenSslPrivateKey = ConfigUtils.getPath((Config)config, (String)"openssl.privateKey");
            IOUtils.assertAccessibleFile((Path)sslOpenSslKeyCertChain, (String)"OpenSSL key certificate chain file");
            IOUtils.assertAccessibleFile((Path)sslOpenSslPrivateKey, (String)"OpenSSL private key file");
            builder.keyManager((InputStream)new BufferedInputStream(new FileInputStream(sslOpenSslKeyCertChain.toFile())), (InputStream)new BufferedInputStream(new FileInputStream(sslOpenSslPrivateKey.toFile())));
        }
        if (!(cipherSuites = config.getStringList("cipherSuites")).isEmpty()) {
            builder.ciphers((Iterable)cipherSuites);
        }
        SslContext sslContext = builder.build();
        return new NettySslHandlerFactory(sslContext);
    }

    private static TrustManagerFactory createTrustManagerFactory(Config config) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (config.hasPath("truststore.path") != config.hasPath("truststore.password")) {
            throw new IllegalArgumentException("Settings dsbulk.driver.ssl.truststore.path, dsbulk.driver.ssl.truststore.password and dsbulk.driver.ssl.truststore.algorithm must be provided together or not at all");
        }
        TrustManagerFactory tmf = null;
        if (config.hasPath("truststore.path")) {
            Path sslTrustStorePath = ConfigUtils.getPath((Config)config, (String)"truststore.path");
            IOUtils.assertAccessibleFile((Path)sslTrustStorePath, (String)"SSL truststore file");
            String sslTrustStorePassword = config.getString("truststore.password");
            String sslTrustStoreAlgorithm = config.getString("truststore.algorithm");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new BufferedInputStream(new FileInputStream(sslTrustStorePath.toFile())), sslTrustStorePassword.toCharArray());
            tmf = TrustManagerFactory.getInstance(sslTrustStoreAlgorithm);
            tmf.init(ks);
        }
        return tmf;
    }

    private static KeyManagerFactory createKeyManagerFactory(Config config) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (config.hasPath("keystore.path") != config.hasPath("keystore.password")) {
            throw new IllegalArgumentException("Settings dsbulk.driver.ssl.keystore.path, dsbulk.driver.ssl.keystore.password and dsbulk.driver.ssl.keystore.algorithm must be provided together or not at all when using the JDK SSL provider");
        }
        KeyManagerFactory kmf = null;
        if (config.hasPath("keystore.path")) {
            Path sslKeyStorePath = ConfigUtils.getPath((Config)config, (String)"keystore.path");
            IOUtils.assertAccessibleFile((Path)sslKeyStorePath, (String)"SSL keystore file");
            String sslKeyStorePassword = config.getString("keystore.password");
            String sslKeyStoreAlgorithm = config.getString("keystore.algorithm");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new BufferedInputStream(new FileInputStream(sslKeyStorePath.toFile())), sslKeyStorePassword.toCharArray());
            kmf = KeyManagerFactory.getInstance(sslKeyStoreAlgorithm);
            kmf.init(ks, sslKeyStorePassword.toCharArray());
        }
        return kmf;
    }
}

