/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.ssl;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.ssl.SslHandlerFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class NettySslHandlerFactory
implements SslHandlerFactory {
    private final SslContext sslContext;

    NettySslHandlerFactory(@NonNull SslContext sslContext) {
        this.sslContext = sslContext;
    }

    public SslHandler newSslHandler(Channel channel, EndPoint remoteEndpoint) {
        InetSocketAddress address = (InetSocketAddress)remoteEndpoint.resolve();
        SslHandler sslHandler = this.sslContext.newHandler(channel.alloc(), address.getHostName(), address.getPort());
        SSLEngine sslEngine = sslHandler.engine();
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        sslEngine.setSSLParameters(sslParameters);
        return sslHandler;
    }

    public void close() {
    }
}

