/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.settings;

import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.util.EnumSet;
import java.util.List;

public class StatsSettings {
    private static final String MODES = "modes";
    private static final String NUM_PARTITIONS = "numPartitions";
    private final Config config;
    private List<StatisticsMode> statisticsModes;
    private int numPartitions;

    public StatsSettings(Config config) {
        this.config = config;
    }

    public void init() {
        try {
            this.statisticsModes = this.config.getEnumList(StatisticsMode.class, MODES);
            this.numPartitions = this.config.getInt(NUM_PARTITIONS);
        }
        catch (ConfigException e) {
            throw ConfigUtils.convertConfigException((ConfigException)e, (String)"dsbulk.stats");
        }
    }

    public EnumSet<StatisticsMode> getStatisticsModes() {
        return EnumSet.copyOf(this.statisticsModes);
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public static enum StatisticsMode {
        global,
        ranges,
        hosts,
        partitions;

    }
}

